"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.painlessErrorToMonacoMarker = exports.deserializeField = void 0;
var _monaco = require("@kbn/monaco");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const deserializeField = (dataView, field) => {
  var _field$runtimeField, _dataView$getFormatte, _field$runtimeField2;
  if (field === undefined) {
    return undefined;
  }
  const primitiveType = field !== null && field !== void 0 && field.esTypes ? field.esTypes[0] : 'keyword';
  const editType = ((_field$runtimeField = field.runtimeField) === null || _field$runtimeField === void 0 ? void 0 : _field$runtimeField.type) === 'composite' ? 'composite' : primitiveType;
  return {
    name: field.name,
    type: editType,
    script: field.runtimeField ? field.runtimeField.script : undefined,
    customLabel: field.customLabel,
    popularity: field.count,
    format: (_dataView$getFormatte = dataView.getFormatterForFieldNoDefault(field.name)) === null || _dataView$getFormatte === void 0 ? void 0 : _dataView$getFormatte.toJSON(),
    fields: (_field$runtimeField2 = field.runtimeField) === null || _field$runtimeField2 === void 0 ? void 0 : _field$runtimeField2.fields
  };
};
exports.deserializeField = deserializeField;
const painlessErrorToMonacoMarker = ({
  reason
}, startPosition) => {
  return {
    startLineNumber: startPosition.lineNumber,
    startColumn: startPosition.column,
    endLineNumber: startPosition.lineNumber,
    // Ideally we'd want the endColumn to be the end of the error but
    // ES does not return that info. There is an issue to track the enhancement:
    // https://github.com/elastic/elasticsearch/issues/78072
    endColumn: startPosition.column + 1,
    message: reason,
    severity: _monaco.monaco.MarkerSeverity.Error
  };
};
exports.painlessErrorToMonacoMarker = painlessErrorToMonacoMarker;