"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewEditorPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _open_editor = require("./open_editor");
var _data_view_editor = require("./components/data_view_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DataViewEditorPlugin {
  setup(core, plugins) {
    return {};
  }
  start(core, plugins) {
    const {
      application,
      uiSettings,
      docLinks,
      http,
      notifications,
      overlays
    } = core;
    const {
      data,
      dataViews
    } = plugins;
    return {
      /**
       * Data view editor flyout via function interface
       * @param DataViewEditorProps - data view editor config
       * @returns method to close editor
       */
      openEditor: (0, _open_editor.getEditorOpener)({
        core,
        dataViews,
        searchClient: data.search.search
      }),
      /**
       * Data view editor flyout via react component
       * @param DataViewEditorProps - data view editor config
       * @returns JSX.Element
       */
      IndexPatternEditorComponent: props => /*#__PURE__*/_react.default.createElement(_data_view_editor.DataViewEditor, (0, _extends2.default)({
        services: {
          uiSettings,
          docLinks,
          http,
          notifications,
          application,
          overlays,
          dataViews,
          searchClient: data.search.search
        }
      }, props)),
      /**
       * Convenience method to determine whether the user can create or edit edit data views.
       *
       * @returns boolean
       */
      userPermissions: {
        editDataView: () => dataViews.getCanSaveSync()
      }
    };
  }
  stop() {
    return {};
  }
}
exports.DataViewEditorPlugin = DataViewEditorPlugin;