"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RollupBetaWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const rollupBetaWarningTitle = _i18n.i18n.translate('indexPatternEditor.rollupIndexPattern.warning.title', {
  defaultMessage: 'Beta feature'
});
const RollupBetaWarning = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: rollupBetaWarningTitle,
  color: "warning",
  iconType: "help"
}, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.rollupDataView.warning.textParagraphOne",
  defaultMessage: "Kibana has beta support for data views based on rollups. You might encounter\nissues using these in saved searches, visualizations, and dashboards. They\nare not supported in some advanced features, such as Timelion, and Machine Learning."
})), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.rollupDataView.warning.textParagraphTwo",
  defaultMessage: "You can match a rollup data view against one rollup index and zero or more\nregular indices. A rollup data view has limited metrics, fields, intervals, and\naggregations. A rollup index is limited to indices that have one job configuration,\nor multiple jobs with compatible configurations."
})));
exports.RollupBetaWarning = RollupBetaWarning;