"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardFailureDescriptionHeader = ShardFailureDescriptionHeader;
exports.getFailurePropsForSummary = getFailurePropsForSummary;
exports.getFailureSummaryDetailsText = getFailureSummaryDetailsText;
exports.getFailureSummaryText = getFailureSummaryText;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getFailurePropsForSummary(failure) {
  const failureDetailProps = ['shard', 'index', 'node'];
  return failureDetailProps.filter(key => typeof failure[key] === 'number' || typeof failure[key] === 'string').map(key => ({
    key,
    value: String(failure[key])
  }));
}
function getFailureSummaryText(failure, failureDetails) {
  const failureName = failure.reason.type;
  const displayDetails = typeof failureDetails === 'string' ? failureDetails : getFailureSummaryDetailsText(failure);
  return _i18n.i18n.translate('data.search.searchSource.fetch.shardsFailedModal.failureHeader', {
    defaultMessage: '{failureName} at {failureDetails}',
    values: {
      failureName,
      failureDetails: displayDetails
    },
    description: 'Summary of shard failures, e.g. "IllegalArgumentException at shard 0 node xyz"'
  });
}
function getFailureSummaryDetailsText(failure) {
  return getFailurePropsForSummary(failure).map(({
    key,
    value
  }) => `${key}: ${value}`).join(', ');
}
function ShardFailureDescriptionHeader(props) {
  const failureDetails = getFailurePropsForSummary(props).map(kv => /*#__PURE__*/_react.default.createElement("span", {
    className: "shardFailureModal__keyValueTitle",
    key: kv.key
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, kv.key), " ", kv.value));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, getFailureSummaryText(props, ''), failureDetails));
}