"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardFailureDescription = ShardFailureDescription;
exports.formatKey = formatKey;
exports.formatValueByKey = formatValueByKey;
var _react = _interopRequireDefault(require("react"));
var _std = require("@kbn/std");
var _eui = require("@elastic/eui");
var _shard_failure_description_header = require("./shard_failure_description_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Provides pretty formatting of a given key string
 * e.g. formats "this_key.is_nice" to "This key is nice"
 * @param key
 */
function formatKey(key) {
  const nameCapitalized = key.charAt(0).toUpperCase() + key.slice(1);
  return nameCapitalized.replace(/[\._]/g, ' ');
}
/**
 * Adds a EuiCodeBlock to values of  `script` and `script_stack` key
 * Values of other keys are handled a strings
 * @param value
 * @param key
 */
function formatValueByKey(value, key) {
  if (key === 'script' || key === 'script_stack') {
    const valueScript = Array.isArray(value) ? value.join('\n') : String(value);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "java",
      paddingSize: "s",
      isCopyable: true
    }, valueScript);
  } else {
    return String(value);
  }
}
function ShardFailureDescription(props) {
  const flattendReason = (0, _std.getFlattenedObject)(props.reason);
  const listItems = Object.entries(flattendReason).map(([key, value]) => ({
    title: formatKey(key),
    description: formatValueByKey(value, key)
  }));
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_shard_failure_description_header.ShardFailureDescriptionHeader, props), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: listItems,
    type: "column",
    compressed: true,
    className: "shardFailureModal__desc",
    titleProps: {
      className: 'shardFailureModal__descTitle'
    },
    descriptionProps: {
      className: 'shardFailureModal__descValue'
    }
  }));
}