"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardStorage = void 0;
var _contentManagementUtils = require("@kbn/content-management-utils");
var _content_management = require("../../common/content_management");
var _cm_services = require("../../common/content_management/cm_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const searchArgsToSOFindOptions = args => {
  const {
    query,
    contentTypeId,
    options
  } = args;
  return {
    type: contentTypeId,
    searchFields: options !== null && options !== void 0 && options.onlyTitle ? ['title'] : ['title^3', 'description'],
    fields: ['description', 'title', 'timeRestore'],
    search: query.text,
    perPage: query.limit,
    page: query.cursor ? +query.cursor : undefined,
    defaultSearchOperator: 'AND',
    ...(0, _contentManagementUtils.tagsToFindOptions)(query.tags)
  };
};
class DashboardStorage extends _contentManagementUtils.SOContentStorage {
  constructor() {
    super({
      savedObjectType: _content_management.CONTENT_ID,
      cmServicesDefinition: _cm_services.cmServicesDefinition,
      searchArgsToSOFindOptions,
      enableMSearch: true,
      allowedSavedObjectAttributes: ['kibanaSavedObjectMeta', 'controlGroupInput', 'refreshInterval', 'description', 'timeRestore', 'optionsJSON', 'panelsJSON', 'timeFrom', 'timeTo', 'title']
    });
  }
}
exports.DashboardStorage = DashboardStorage;