"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unsavedChangesDiffingFunctions = exports.shouldRefreshDiffingFunctions = exports.isKeyEqualAsync = exports.isKeyEqual = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _common = require("@kbn/controls-plugin/common");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/embeddable-plugin/public");
var _dashboard_diffing_utils = require("./dashboard_diffing_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isKeyEqualAsync = async (key, diffFunctionProps, diffingFunctions) => {
  const propsAsNever = diffFunctionProps; // todo figure out why props has conflicting types in some constituents.
  const diffingFunction = diffingFunctions[key];
  if (diffingFunction) {
    var _diffingFunction$prot;
    return (diffingFunction === null || diffingFunction === void 0 ? void 0 : (_diffingFunction$prot = diffingFunction.prototype) === null || _diffingFunction$prot === void 0 ? void 0 : _diffingFunction$prot.name) === 'AsyncFunction' ? await diffingFunction(propsAsNever) : diffingFunction(propsAsNever);
  }
  return (0, _fastDeepEqual.default)(diffFunctionProps.currentValue, diffFunctionProps.lastValue);
};
exports.isKeyEqualAsync = isKeyEqualAsync;
const isKeyEqual = (key, diffFunctionProps, diffingFunctions) => {
  var _diffingFunction$prot2;
  const propsAsNever = diffFunctionProps; // todo figure out why props has conflicting types in some constituents.
  const diffingFunction = diffingFunctions[key];
  if (!diffingFunction) {
    return (0, _fastDeepEqual.default)(diffFunctionProps.currentValue, diffFunctionProps.lastValue);
  }
  if ((diffingFunction === null || diffingFunction === void 0 ? void 0 : (_diffingFunction$prot2 = diffingFunction.prototype) === null || _diffingFunction$prot2 === void 0 ? void 0 : _diffingFunction$prot2.name) === 'AsyncFunction') {
    throw new Error(`The function for key "${key}" is async, must use isKeyEqualAsync for asynchronous functions`);
  }
  return diffingFunction(propsAsNever);
};

/**
 * A collection of functions which diff individual keys of dashboard state. If a key is missing from this list it is
 * diffed by the default diffing function, fastIsEqual.
 */
exports.isKeyEqual = isKeyEqual;
const unsavedChangesDiffingFunctions = {
  panels: async ({
    currentValue,
    lastValue,
    container
  }) => {
    if (!(0, _dashboard_diffing_utils.getPanelLayoutsAreEqual)(currentValue, lastValue)) return false;
    const explicitInputComparePromises = Object.values(currentValue).map(panel => new Promise((resolve, reject) => {
      const embeddableId = panel.explicitInput.id;
      if (!embeddableId) reject();
      try {
        container.untilEmbeddableLoaded(embeddableId).then(embeddable => embeddable.getExplicitInputIsEqual(lastValue[embeddableId].explicitInput).then(isEqual => {
          if (isEqual) {
            // rejecting the promise if the input is equal.
            reject();
          } else {
            // resolving false here means that the panel is unequal. The first promise to resolve this way will return false from this function.
            resolve(false);
          }
        }));
      } catch (e) {
        reject();
      }
    }));

    // If any promise resolves, return false. The catch here is only called if all promises reject which means all panels are equal.
    return await Promise.any(explicitInputComparePromises).catch(() => true);
  },
  // exclude pinned filters from comparision because pinned filters are not part of application state
  filters: ({
    currentValue,
    lastValue
  }) => (0, _esQuery.compareFilters)(currentValue.filter(f => !(0, _esQuery.isFilterPinned)(f)), lastValue.filter(f => !(0, _esQuery.isFilterPinned)(f)), _esQuery.COMPARE_ALL_OPTIONS),
  timeRange: ({
    currentValue,
    lastValue,
    currentInput
  }) => {
    if (!currentInput.timeRestore) return true; // if time restore is set to false, time range doesn't count as a change.
    if (!(0, _dashboard_diffing_utils.areTimesEqual)(currentValue === null || currentValue === void 0 ? void 0 : currentValue.from, lastValue === null || lastValue === void 0 ? void 0 : lastValue.from) || !(0, _dashboard_diffing_utils.areTimesEqual)(currentValue === null || currentValue === void 0 ? void 0 : currentValue.to, lastValue === null || lastValue === void 0 ? void 0 : lastValue.to)) {
      return false;
    }
    return true;
  },
  refreshInterval: ({
    currentValue,
    lastValue,
    currentInput
  }) => {
    if (!currentInput.timeRestore) return true; // if time restore is set to false, refresh interval doesn't count as a change.
    return (0, _fastDeepEqual.default)(currentValue, lastValue);
  },
  controlGroupInput: ({
    currentValue,
    lastValue
  }) => (0, _common.persistableControlGroupInputIsEqual)(currentValue, lastValue),
  viewMode: () => false // When compared view mode is always considered unequal so that it gets backed up.
};
exports.unsavedChangesDiffingFunctions = unsavedChangesDiffingFunctions;
const shouldRefreshDiffingFunctions = {
  filters: ({
    currentValue,
    lastValue
  }) => (0, _esQuery.onlyDisabledFiltersChanged)(lastValue, currentValue, _public.shouldRefreshFilterCompareOptions),
  // fire on all time range changes, regardless of timeRestore
  timeRange: ({
    currentValue,
    lastValue
  }) => (0, _dashboard_diffing_utils.areTimesEqual)(currentValue === null || currentValue === void 0 ? void 0 : currentValue.from, lastValue === null || lastValue === void 0 ? void 0 : lastValue.from) && (0, _dashboard_diffing_utils.areTimesEqual)(currentValue === null || currentValue === void 0 ? void 0 : currentValue.to, lastValue === null || lastValue === void 0 ? void 0 : lastValue.to)
};
exports.shouldRefreshDiffingFunctions = shouldRefreshDiffingFunctions;