"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardSaveModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/saved-objects-plugin/public");
var _plugin_services = require("../../../../services/plugin_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DashboardSaveModal extends _react.default.Component {
  constructor(props) {
    var _this$props$tags;
    super(props);
    (0, _defineProperty2.default)(this, "state", {
      timeRestore: this.props.timeRestore,
      tags: (_this$props$tags = this.props.tags) !== null && _this$props$tags !== void 0 ? _this$props$tags : []
    });
    (0, _defineProperty2.default)(this, "saveDashboard", ({
      newTitle,
      newDescription,
      newCopyOnSave,
      isTitleDuplicateConfirmed,
      onTitleDuplicate
    }) => {
      this.props.onSave({
        newTitle,
        newDescription,
        newCopyOnSave,
        newTimeRestore: this.state.timeRestore,
        isTitleDuplicateConfirmed,
        onTitleDuplicate,
        newTags: this.state.tags
      });
    });
    (0, _defineProperty2.default)(this, "onTimeRestoreChange", event => {
      this.setState({
        timeRestore: event.target.checked
      });
    });
  }
  renderDashboardSaveOptions() {
    const {
      savedObjectsTagging: {
        components
      }
    } = _plugin_services.pluginServices.getServices();
    const tagSelector = components ? /*#__PURE__*/_react.default.createElement(components.SavedObjectSaveModalTagSelector, {
      initialSelection: this.state.tags,
      onTagsSelected: tags => {
        this.setState({
          tags
        });
      },
      markOptional: true
    }) : undefined;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, tagSelector, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.topNav.saveModal.storeTimeWithDashboardFormRowHelpText",
        defaultMessage: "This changes the time filter to the currently selected time each time this dashboard is loaded."
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      "data-test-subj": "storeTimeWithDashboard",
      checked: this.state.timeRestore,
      onChange: this.onTimeRestoreChange,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.topNav.saveModal.storeTimeWithDashboardFormRowLabel",
        defaultMessage: "Store time with dashboard"
      })
    })));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModal, {
      onSave: this.saveDashboard,
      onClose: this.props.onClose,
      title: this.props.title,
      description: this.props.description,
      showDescription: true,
      showCopyOnSave: this.props.showCopyOnSave,
      initialCopyOnSave: this.props.showCopyOnSave,
      objectType: _i18n.i18n.translate('dashboard.topNav.saveModal.objectType', {
        defaultMessage: 'dashboard'
      }),
      options: this.renderDashboardSaveOptions()
    });
  }
}
exports.DashboardSaveModal = DashboardSaveModal;