"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardEditingToolbar = DashboardEditingToolbar;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _dashboard_app_strings = require("../_dashboard_app_strings");
var _editor_menu = require("./editor_menu");
var _dashboard_app = require("../dashboard_app");
var _plugin_services = require("../../services/plugin_services");
var _controls_toolbar_button = require("./controls_toolbar_button");
var _dashboard_constants = require("../../dashboard_constants");
var _dashboard_actions_strings = require("../../dashboard_actions/_dashboard_actions_strings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DashboardEditingToolbar() {
  var _usageCollection$repo;
  const {
    usageCollection,
    data: {
      search
    },
    notifications: {
      toasts
    },
    embeddable: {
      getStateTransfer,
      getEmbeddableFactory
    },
    visualizations: {
      get: getVisualization,
      getAliases: getVisTypeAliases
    }
  } = _plugin_services.pluginServices.getServices();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dashboard = (0, _dashboard_app.useDashboardAPI)();
  const stateTransferService = getStateTransfer();
  const lensAlias = getVisTypeAliases().find(({
    name
  }) => name === 'lens');
  const quickButtonVisTypes = [{
    type: 'vis',
    visType: 'markdown'
  }, {
    type: 'embeddable',
    embeddableType: 'image'
  }, {
    type: 'vis',
    visType: 'maps'
  }];
  const trackUiMetric = (_usageCollection$repo = usageCollection.reportUiCounter) === null || _usageCollection$repo === void 0 ? void 0 : _usageCollection$repo.bind(usageCollection, _dashboard_constants.DASHBOARD_UI_METRIC_ID);
  const createNewVisType = (0, _react2.useCallback)(visType => () => {
    let path = '';
    let appId = '';
    if (visType) {
      if (trackUiMetric) {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, `${visType.name}:create`);
      }
      if ('aliasPath' in visType) {
        appId = visType.aliasApp;
        path = visType.aliasPath;
      } else {
        appId = 'visualize';
        path = `#/create?type=${encodeURIComponent(visType.name)}`;
      }
    } else {
      appId = 'visualize';
      path = '#/create?';
    }
    stateTransferService.navigateToEditor(appId, {
      path,
      state: {
        originatingApp: _dashboard_constants.DASHBOARD_APP_ID,
        searchSessionId: search.session.getSessionId()
      }
    });
  }, [stateTransferService, search.session, trackUiMetric]);
  const createNewEmbeddable = (0, _react2.useCallback)(async embeddableFactory => {
    if (trackUiMetric) {
      trackUiMetric(_analytics.METRIC_TYPE.CLICK, embeddableFactory.type);
    }
    let explicitInput;
    try {
      explicitInput = await embeddableFactory.getExplicitInput();
    } catch (e) {
      // error likely means user canceled embeddable creation
      return;
    }
    const newEmbeddable = await dashboard.addNewEmbeddable(embeddableFactory.type, explicitInput);
    if (newEmbeddable) {
      dashboard.setScrollToPanelId(newEmbeddable.id);
      dashboard.setHighlightPanelId(newEmbeddable.id);
      toasts.addSuccess({
        title: _dashboard_actions_strings.dashboardReplacePanelActionStrings.getSuccessMessage(newEmbeddable.getTitle()),
        'data-test-subj': 'addEmbeddableToDashboardSuccess'
      });
    }
  }, [trackUiMetric, dashboard, toasts]);
  const getVisTypeQuickButton = quickButtonForType => {
    if (quickButtonForType.type === 'vis') {
      const visTypeName = quickButtonForType.visType;
      const visType = getVisualization(visTypeName) || getVisTypeAliases().find(({
        name
      }) => name === visTypeName);
      if (visType) {
        if ('aliasPath' in visType) {
          const {
            name,
            icon,
            title
          } = visType;
          return {
            label: title,
            iconType: icon,
            onClick: createNewVisType(visType),
            'data-test-subj': `dashboardQuickButton${name}`
          };
        } else {
          const {
            name,
            icon,
            title,
            titleInWizard
          } = visType;
          return {
            label: titleInWizard || title,
            iconType: icon,
            onClick: createNewVisType(visType),
            'data-test-subj': `dashboardQuickButton${name}`
          };
        }
      }
    } else {
      const embeddableType = quickButtonForType.embeddableType;
      const embeddableFactory = getEmbeddableFactory(embeddableType);
      if (embeddableFactory) {
        return {
          label: embeddableFactory.getDisplayName(),
          iconType: embeddableFactory.getIconType(),
          onClick: () => {
            if (embeddableFactory) {
              createNewEmbeddable(embeddableFactory);
            }
          },
          'data-test-subj': `dashboardQuickButton${embeddableType}`
        };
      }
    }
  };
  const quickButtons = quickButtonVisTypes.reduce((accumulator, type) => {
    const button = getVisTypeQuickButton(type);
    return button ? [...accumulator, button] : accumulator;
  }, []);
  const extraButtons = [/*#__PURE__*/_react2.default.createElement(_editor_menu.EditorMenu, {
    createNewVisType: createNewVisType,
    createNewEmbeddable: createNewEmbeddable
  }), /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.AddFromLibraryButton, {
    onClick: () => dashboard.addFromLibrary(),
    "data-test-subj": "dashboardAddPanelButton"
  })];
  if (dashboard.controlGroup) {
    extraButtons.push( /*#__PURE__*/_react2.default.createElement(_controls_toolbar_button.ControlsToolbarButton, {
      controlGroup: dashboard.controlGroup
    }));
  }
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        padding: 0 ${euiTheme.size.s} ${euiTheme.size.s} ${euiTheme.size.s};
      `
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.Toolbar, null, {
    primaryButton: /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      type: "primary",
      iconType: "lensApp",
      onClick: createNewVisType(lensAlias),
      label: (0, _dashboard_app_strings.getCreateVisualizationButtonTitle)(),
      "data-test-subj": "dashboardAddNewPanelButton"
    }),
    iconButtonGroup: /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.IconButtonGroup, {
      buttons: quickButtons,
      legend: (0, _dashboard_app_strings.getQuickCreateButtonGroupLegend)()
    }),
    extraButtons
  }));
}