"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardDrilldownConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("./i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DashboardDrilldownConfig = ({
  activeDashboardId,
  dashboards,
  currentFilters,
  keepRange,
  openInNewTab,
  onDashboardSelect,
  onCurrentFiltersToggle,
  onKeepRangeToggle,
  onOpenInNewTab,
  onSearchChange,
  isLoading,
  error
}) => {
  var _dashboards$find;
  const selectedTitle = ((_dashboards$find = dashboards.find(item => item.value === activeDashboardId)) === null || _dashboards$find === void 0 ? void 0 : _dashboards$find.label) || '';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.txtChooseDestinationDashboard,
    fullWidth: true,
    isInvalid: !!error,
    error: error
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    async: true,
    selectedOptions: activeDashboardId ? [{
      label: selectedTitle,
      value: activeDashboardId
    }] : [],
    options: dashboards,
    onChange: ([{
      value = ''
    } = {
      value: ''
    }]) => onDashboardSelect(value),
    onSearchChange: onSearchChange,
    isLoading: isLoading,
    singleSelection: {
      asPlainText: true
    },
    fullWidth: true,
    "data-test-subj": 'dashboardDrilldownSelectDashboard',
    isInvalid: !!error
  })), !!onCurrentFiltersToggle && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "useCurrentFilters",
    label: _i18n.txtUseCurrentFilters,
    checked: !!currentFilters,
    onChange: onCurrentFiltersToggle
  })), !!onKeepRangeToggle && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "useCurrentDateRange",
    label: _i18n.txtUseCurrentDateRange,
    checked: !!keepRange,
    onChange: onKeepRangeToggle
  })), !!onOpenInNewTab && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "openInNewTab",
    label: _i18n.txtOpenInNewTab,
    checked: !!openInNewTab,
    onChange: onOpenInNewTab
  })));
};
exports.DashboardDrilldownConfig = DashboardDrilldownConfig;