"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFormErrors = exports.updateFields = exports.FollowerIndexForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _input_validation = require("../../services/input_validation");
var _routing = require("../../services/routing");
var _notifications = require("../../services/notifications");
var _api = require("../../services/api");
var _documentation_links = require("../../services/documentation_links");
var _constants = require("../../constants");
var _get_remote_cluster_name = require("../../services/get_remote_cluster_name");
var _remote_clusters_form_field = require("../remote_clusters_form_field");
var _section_error = require("../section_error");
var _form_entry_row = require("../form_entry_row");
var _advanced_settings_fields = require("./advanced_settings_fields");
var _follower_index_request_flyout = require("./follower_index_request_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexNameIllegalCharacters = _shared_imports.indices.INDEX_ILLEGAL_CHARACTERS_VISIBLE.join(' ');
const getFieldToValidatorMap = advancedSettingsFields => advancedSettingsFields.reduce((map, advancedSetting) => {
  const {
    field,
    validator
  } = advancedSetting;
  map[field] = validator;
  return map;
}, {
  name: _input_validation.indexNameValidator,
  leaderIndex: _input_validation.leaderIndexValidator
});
const getEmptyFollowerIndex = (remoteClusterName = '') => ({
  name: '',
  remoteCluster: remoteClusterName,
  leaderIndex: '',
  ...(0, _advanced_settings_fields.getEmptyAdvancedSettings)(_documentation_links.documentationLinks)
});

/**
 * State transitions: fields update
 */
const updateFields = fields => ({
  followerIndex
}) => ({
  followerIndex: {
    ...followerIndex,
    ...fields
  }
});

/**
 * State transitions: errors update
 */
exports.updateFields = updateFields;
const updateFormErrors = errors => ({
  fieldsErrors
}) => ({
  fieldsErrors: {
    ...fieldsErrors,
    ...errors
  }
});
exports.updateFormErrors = updateFormErrors;
class FollowerIndexForm extends _react.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "toggleRequest", () => {
      this.setState(({
        isRequestVisible
      }) => ({
        isRequestVisible: !isRequestVisible
      }));
    });
    (0, _defineProperty2.default)(this, "onFieldsChange", fields => {
      this.setState(updateFields(fields));
      const newFields = {
        ...this.state.fields,
        ...fields
      };
      this.setState(updateFormErrors(this.getFieldsErrors(newFields)));
      if (this.props.apiError) {
        this.props.clearApiError();
      }
    });
    (0, _defineProperty2.default)(this, "getFieldsErrors", newFields => {
      return Object.keys(newFields).reduce((errors, field) => {
        const advancedSettings = (0, _advanced_settings_fields.getAdvancedSettingsFields)(_documentation_links.documentationLinks);
        const validator = getFieldToValidatorMap(advancedSettings)[field];
        const value = newFields[field];
        if (validator) {
          const error = validator(value);
          errors[field] = error;
        }
        return errors;
      }, {});
    });
    (0, _defineProperty2.default)(this, "onIndexNameChange", ({
      name
    }) => {
      this.onFieldsChange({
        name
      });
      const error = (0, _input_validation.indexNameValidator)(name);
      if (error) {
        // If there is a client side error
        // there is no need to validate the name
        return;
      }
      if (!name || !name.trim()) {
        this.setState({
          isValidatingIndexName: false
        });
        return;
      }
      this.setState({
        isValidatingIndexName: true
      });
      this.validateIndexName(name);
    });
    (0, _defineProperty2.default)(this, "validateIndexName", async name => {
      try {
        const indices = await (0, _api.loadIndices)();
        const doesExist = indices.some(index => index.name === name);
        if (doesExist) {
          const error = {
            message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.crossClusterReplication.followerIndexForm.indexAlreadyExistError",
              defaultMessage: "An index with the same name already exists."
            }),
            alwaysVisible: true
          };
          this.setState(updateFormErrors({
            name: error
          }));
        }
        this.setState({
          isValidatingIndexName: false
        });
      } catch (error) {
        if (error) {
          if (error.name === 'AbortError') {
            // Ignore aborted requests
            return;
          }
          // This could be an HTTP error
          if (error.body) {
            // All validation does is check for a name collision, so we can just let the user attempt
            // to save the follower index and get an error back from the API.
            return this.setState({
              isValidatingIndexName: false
            });
          }
        }

        // This error isn't an HTTP error, so let the fatal error screen tell the user something
        // unexpected happened.
        (0, _notifications.getFatalErrors)().add(error, _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.indexNameValidationFatalErrorTitle', {
          defaultMessage: 'Follower Index Form index name validation'
        }));
      }
    });
    (0, _defineProperty2.default)(this, "onClusterChange", remoteCluster => {
      this.onFieldsChange({
        remoteCluster
      });
    });
    (0, _defineProperty2.default)(this, "getFields", () => {
      return this.state.followerIndex;
    });
    (0, _defineProperty2.default)(this, "toggleAdvancedSettings", event => {
      // If the user edits the advanced settings but then hides them, we need to make sure the
      // edited values don't get sent to the API when the user saves, but we *do* want to restore
      // these values to the form when the user re-opens the advanced settings.
      if (event.target.checked) {
        // Apply the cached advanced settings to the advanced settings form.
        this.onFieldsChange(this.cachedAdvancedSettings);

        // Reset the cache of the advanced settings.
        this.cachedAdvancedSettings = {};

        // Show the advanced settings.
        return this.setState({
          areAdvancedSettingsVisible: true
        });
      }

      // Clear the advanced settings form.
      this.onFieldsChange((0, _advanced_settings_fields.getEmptyAdvancedSettings)(_documentation_links.documentationLinks));

      // Save a cache of the advanced settings.
      const fields = this.getFields();
      this.cachedAdvancedSettings = (0, _advanced_settings_fields.getAdvancedSettingsFields)(_documentation_links.documentationLinks).reduce((cache, {
        field
      }) => {
        const value = fields[field];
        if (value !== '') {
          cache[field] = value;
        }
        return cache;
      }, {});

      // Hide the advanced settings.
      this.setState({
        areAdvancedSettingsVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "sendForm", () => {
      const isFormValid = this.isFormValid();
      this.setState({
        areErrorsVisible: !isFormValid
      });
      if (!isFormValid) {
        return;
      }
      const {
        name,
        ...followerIndex
      } = this.getFields();
      this.props.saveFollowerIndex(name, followerIndex);
    });
    (0, _defineProperty2.default)(this, "cancelForm", () => {
      _routing.routing.navigate('/follower_indices');
    });
    (0, _defineProperty2.default)(this, "renderForm", () => {
      const {
        followerIndex,
        isNew,
        areErrorsVisible,
        areAdvancedSettingsVisible,
        fieldsErrors,
        isValidatingIndexName
      } = this.state;

      /**
       * Follower index name
       */

      const indexNameHelpText = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isValidatingIndexName && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexForm.indexNameValidatingLabel",
        defaultMessage: "Checking availability\u2026"
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexForm.indexNameHelpLabel",
        defaultMessage: "Spaces and the characters {characterList} are not allowed.",
        values: {
          characterList: /*#__PURE__*/_react.default.createElement("strong", null, indexNameIllegalCharacters)
        }
      })));
      const indexNameLabel = _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.sectionFollowerIndexNameTitle', {
        defaultMessage: 'Follower index'
      });
      const renderFollowerIndexName = () => /*#__PURE__*/_react.default.createElement(_form_entry_row.FormEntryRow, {
        field: "name",
        value: followerIndex.name,
        error: fieldsErrors.name,
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
          size: "s"
        }, /*#__PURE__*/_react.default.createElement("h2", null, indexNameLabel)),
        label: indexNameLabel,
        description: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.sectionFollowerIndexNameDescription', {
          defaultMessage: 'A unique name for your index.'
        }),
        helpText: indexNameHelpText,
        isLoading: isValidatingIndexName,
        disabled: !isNew,
        areErrorsVisible: areErrorsVisible,
        onValueUpdate: this.onIndexNameChange,
        testSubj: "followerIndexInput"
      });

      /**
       * Remote Cluster
       */
      const renderRemoteClusterField = () => {
        const {
          remoteClusters,
          currentUrl
        } = this.props;
        const errorMessages = {
          noClusterFound: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.followerIndexForm.emptyRemoteClustersCallOutDescription",
            defaultMessage: "Replication requires a leader index on a remote cluster."
          }),
          remoteClusterNotConnectedNotEditable: name => ({
            title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.crossClusterReplication.followerIndexForm.currentRemoteClusterNotConnectedCallOutTitle",
              defaultMessage: "Can't edit follower index because remote cluster '{name}' is not connected",
              values: {
                name
              }
            }),
            description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.crossClusterReplication.followerIndexForm.currentRemoteClusterNotConnectedCallOutDescription",
              defaultMessage: "You can address this by editing the remote cluster."
            })
          }),
          remoteClusterDoesNotExist: name => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.followerIndexForm.currentRemoteClusterNotFoundCallOutDescription",
            defaultMessage: "To edit this follower index, you must add a remote cluster named '{name}'.",
            values: {
              name
            }
          })
        };
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
            size: "s"
          }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.followerIndexForm.sectionRemoteClusterTitle",
            defaultMessage: "Remote cluster"
          }))),
          description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.followerIndexForm.sectionRemoteClusterDescription",
            defaultMessage: "The cluster that contains the index to replicate."
          }),
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_remote_clusters_form_field.RemoteClustersFormField, {
          selected: followerIndex.remoteCluster ? followerIndex.remoteCluster : null,
          remoteClusters: remoteClusters || [],
          currentUrl: currentUrl,
          isEditable: isNew,
          areErrorsVisible: areErrorsVisible,
          onChange: this.onClusterChange,
          onError: error => {
            this.setState(updateFormErrors({
              remoteCluster: error
            }));
          },
          errorMessages: errorMessages
        }));
      };

      /**
       * Leader index
       */

      const leaderIndexLabel = _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.sectionLeaderIndexTitle', {
        defaultMessage: 'Leader index'
      });
      const renderLeaderIndex = () => /*#__PURE__*/_react.default.createElement(_form_entry_row.FormEntryRow, {
        field: "leaderIndex",
        value: followerIndex.leaderIndex,
        error: fieldsErrors.leaderIndex,
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
          size: "s"
        }, /*#__PURE__*/_react.default.createElement("h2", null, leaderIndexLabel)),
        label: leaderIndexLabel,
        description: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexForm.sectionLeaderIndexDescription",
          defaultMessage: "The index on the remote cluster to replicate to the follower index."
        })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexForm.sectionLeaderIndexDescription2",
          defaultMessage: "{note} The leader index must already exist.",
          values: {
            note: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.crossClusterReplication.followerIndexForm.sectionLeaderIndexDescription2.noteLabel",
              defaultMessage: "Note:"
            }))
          }
        }))),
        helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexForm.indexNameHelpLabel",
          defaultMessage: "Spaces and the characters {characterList} are not allowed.",
          values: {
            characterList: /*#__PURE__*/_react.default.createElement("strong", null, indexNameIllegalCharacters)
          }
        }),
        disabled: !isNew,
        areErrorsVisible: areErrorsVisible,
        onValueUpdate: this.onFieldsChange,
        testSubj: "leaderIndexInput"
      });

      /**
       * Advanced settings
       */

      const renderAdvancedSettings = () => {
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
            size: "s"
          }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.followerIndexForm.advancedSettingsTitle",
            defaultMessage: "Advanced settings (optional)"
          }))),
          description: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.followerIndexForm.advancedSettingsDescription",
            defaultMessage: "Advanced settings control the rate of replication. You can customize these settings or use the default values."
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
            label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.crossClusterReplication.followerIndex.advancedSettingsForm.showSwitchLabel",
              defaultMessage: "Customize advanced settings"
            }),
            checked: areAdvancedSettingsVisible,
            onChange: this.toggleAdvancedSettings,
            "data-test-subj": "advancedSettingsToggle"
          })),
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null), " "), areAdvancedSettingsVisible && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "s"
        }), (0, _advanced_settings_fields.getAdvancedSettingsFields)(_documentation_links.documentationLinks).map(advancedSetting => {
          const {
            field,
            testSubject,
            title,
            description,
            label,
            helpText,
            defaultValue,
            type
          } = advancedSetting;
          return /*#__PURE__*/_react.default.createElement(_form_entry_row.FormEntryRow, {
            key: field,
            field: field,
            value: followerIndex[field],
            defaultValue: defaultValue,
            error: fieldsErrors[field],
            title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
              size: "xs"
            }, /*#__PURE__*/_react.default.createElement("h3", null, title)),
            description: description,
            label: label,
            helpText: helpText,
            type: type,
            areErrorsVisible: areErrorsVisible,
            onValueUpdate: this.onFieldsChange,
            testSubj: testSubject
          });
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null));
      };

      /**
       * Form Error warning message
       */
      const renderFormErrorWarning = () => {
        const {
          areErrorsVisible
        } = this.state;
        const isFormValid = this.isFormValid();
        if (!areErrorsVisible || isFormValid) {
          return null;
        }
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.followerIndexForm.validationErrorTitle",
            defaultMessage: "Fix errors before continuing."
          }),
          color: "danger",
          iconType: "cross",
          "data-test-subj": "formError"
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "l"
        }));
      };

      /**
       * Form Actions
       */
      const renderActions = () => {
        const {
          apiStatus,
          saveButtonLabel
        } = this.props;
        const {
          areErrorsVisible,
          isRequestVisible
        } = this.state;
        if (apiStatus === _constants.API_STATUS.SAVING) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            justifyContent: "flexStart",
            gutterSize: "m"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            size: "l"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.followerIndexForm.actions.savingText",
            defaultMessage: "Saving"
          }))));
        }
        const isSaveDisabled = areErrorsVisible && !this.isFormValid();
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "spaceBetween",
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "m",
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          color: "success",
          iconType: "check",
          onClick: this.sendForm,
          fill: true,
          disabled: isSaveDisabled,
          "data-test-subj": "submitButton"
        }, saveButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          color: "primary",
          onClick: this.cancelForm,
          "data-test-subj": "cancelButton"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexForm.cancelButtonLabel",
          defaultMessage: "Cancel"
        })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          onClick: this.toggleRequest
        }, isRequestVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexForm.hideRequestButtonLabel",
          defaultMessage: "Hide request"
        }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexForm.showRequestButtonLabel",
          defaultMessage: "Show request"
        }))));
      };
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
        "data-test-subj": "followerIndexForm"
      }, renderRemoteClusterField(), renderLeaderIndex(), renderFollowerIndexName(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), renderAdvancedSettings()), renderFormErrorWarning(), this.renderApiErrors(), renderActions());
    });
    (0, _defineProperty2.default)(this, "renderLoading", () => {
      const {
        apiStatus
      } = this.props;
      if (apiStatus === _constants.API_STATUS.SAVING) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
          logo: "logoKibana",
          size: "xl"
        }));
      }
      return null;
    });
    const {
      route: {
        location: {
          search
        }
      }
    } = _routing.routing.reactRouter;
    const queryParams = (0, _shared_imports.extractQueryParams)(search);
    const _isNew = this.props.followerIndex === undefined;
    const remoteClusterName = (0, _get_remote_cluster_name.getRemoteClusterName)(this.props.remoteClusters, queryParams.cluster);
    const _followerIndex = _isNew ? getEmptyFollowerIndex(remoteClusterName) : {
      ...getEmptyFollowerIndex(),
      ...this.props.followerIndex
    };

    // eslint-disable-next-line no-nested-ternary
    const _areAdvancedSettingsVisible = _isNew ? false : (0, _advanced_settings_fields.areAdvancedSettingsEdited)(_followerIndex, _documentation_links.documentationLinks) ? true : false;
    const _fieldsErrors = this.getFieldsErrors(_followerIndex);
    this.state = {
      isNew: _isNew,
      followerIndex: _followerIndex,
      fieldsErrors: _fieldsErrors,
      areErrorsVisible: false,
      areAdvancedSettingsVisible: _areAdvancedSettingsVisible,
      isValidatingIndexName: false,
      isRequestVisible: false
    };
    this.cachedAdvancedSettings = {};
    this.validateIndexName = (0, _lodash.debounce)(this.validateIndexName, 500, {
      trailing: true
    });
  }
  isFormValid() {
    return Object.values(this.state.fieldsErrors).every(error => error === undefined || error === null);
  }
  /**
   * Sections Renders
   */
  renderApiErrors() {
    const {
      apiError
    } = this.props;
    if (apiError) {
      const title = _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.savingErrorTitle', {
        defaultMessage: `Can't create follower index`
      });
      const {
        leaderIndex
      } = this.state.followerIndex;
      const error = apiError.status === 404 ? {
        data: {
          message: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.leaderIndexNotFoundError', {
            defaultMessage: `The leader index '{leaderIndex}' does not exist.`,
            values: {
              leaderIndex
            }
          })
        }
      } : apiError;
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_section_error.SectionError, {
        title: title,
        error: error
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }));
    }
    return null;
  }
  render() {
    const {
      followerIndex,
      isRequestVisible
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this.renderForm(), this.renderLoading(), isRequestVisible ? /*#__PURE__*/_react.default.createElement(_follower_index_request_flyout.FollowerIndexRequestFlyout, {
      name: followerIndex.name,
      followerIndex: this.getFields(),
      close: () => this.setState({
        isRequestVisible: false
      })
    }) : null);
  }
}
exports.FollowerIndexForm = FollowerIndexForm;
(0, _defineProperty2.default)(FollowerIndexForm, "propTypes", {
  saveFollowerIndex: _propTypes.default.func.isRequired,
  clearApiError: _propTypes.default.func.isRequired,
  followerIndex: _propTypes.default.object,
  apiError: _propTypes.default.object,
  apiStatus: _propTypes.default.string.isRequired,
  remoteClusters: _propTypes.default.array,
  saveButtonLabel: _propTypes.default.node
});