"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkIndexCurrentAlgorithm = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * The list of values returned by `checkIndexCurrentAlgorithm`.
 *
 * - `zdt`
 * - `v2-compatible`
 * - `v2-incompatible`
 * - `unknown`
 */

const checkIndexCurrentAlgorithm = indexMapping => {
  const meta = indexMapping._meta;
  if (!meta) {
    return 'unknown';
  }
  const hasV2Meta = !!meta.migrationMappingPropertyHashes;
  const hasZDTMeta = !!meta.docVersions || !!meta.mappingVersions;
  if (hasV2Meta && hasZDTMeta) {
    return 'unknown';
  }
  if (hasV2Meta) {
    const isCompatible = !!meta.indexTypesMap;
    return isCompatible ? 'v2-compatible' : 'v2-incompatible';
  }
  if (hasZDTMeta) {
    return 'zdt';
  }
  return 'unknown';
};
exports.checkIndexCurrentAlgorithm = checkIndexCurrentAlgorithm;