"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateMappings = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Updates an index's mappings and runs an pickupUpdatedMappings task so that the mapping
 * changes are "picked up". Returns a taskId to track progress.
 */
const updateMappings = ({
  client,
  index,
  mappings
}) => {
  return () => {
    return client.indices.putMapping({
      index,
      timeout: _constants.DEFAULT_TIMEOUT,
      ...mappings
    }).then(() => Either.right('update_mappings_succeeded')).catch(res => {
      var _res$body, _res$body$error;
      const errorType = res === null || res === void 0 ? void 0 : (_res$body = res.body) === null || _res$body === void 0 ? void 0 : (_res$body$error = _res$body.error) === null || _res$body$error === void 0 ? void 0 : _res$body$error.type;
      // ES throws this exact error when attempting to make incompatible updates to the mappigns
      if ((res === null || res === void 0 ? void 0 : res.statusCode) === 400 && (errorType === 'illegal_argument_exception' || errorType === 'strict_dynamic_mapping_exception' || errorType === 'mapper_parsing_exception')) {
        return Either.left({
          type: 'incompatible_mapping_exception'
        });
      }
      return (0, _catch_retryable_es_client_errors.catchRetryableEsClientErrors)(res);
    });
  };
};
exports.updateMappings = updateMappings;