"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createXsrfPostAuthHandler = exports.createVersionCheckPostAuthHandler = exports.createRestrictInternalRoutesPostAuthHandler = exports.createCustomHeadersPreResponseHandler = void 0;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _constants = require("@kbn/core-http-common/src/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const VERSION_HEADER = 'kbn-version';
const XSRF_HEADER = 'kbn-xsrf';
const KIBANA_NAME_HEADER = 'kbn-name';
const createXsrfPostAuthHandler = config => {
  const {
    allowlist,
    disableProtection
  } = config.xsrf;
  return (request, response, toolkit) => {
    if (disableProtection || allowlist.includes(request.route.path) || request.route.options.xsrfRequired === false) {
      return toolkit.next();
    }
    const hasVersionHeader = (VERSION_HEADER in request.headers);
    const hasXsrfHeader = (XSRF_HEADER in request.headers);
    if (!(0, _coreHttpRouterServerInternal.isSafeMethod)(request.route.method) && !hasVersionHeader && !hasXsrfHeader) {
      return response.badRequest({
        body: `Request must contain a ${XSRF_HEADER} header.`
      });
    }
    return toolkit.next();
  };
};
exports.createXsrfPostAuthHandler = createXsrfPostAuthHandler;
const createRestrictInternalRoutesPostAuthHandler = config => {
  const isRestrictionEnabled = config.restrictInternalApis;
  return (request, response, toolkit) => {
    const isInternalRoute = request.route.options.access === 'internal';

    // only check if the header is present, not it's content.
    const hasInternalKibanaRequestHeader = (_constants.X_ELASTIC_INTERNAL_ORIGIN_REQUEST in request.headers);
    if (isRestrictionEnabled && isInternalRoute && !hasInternalKibanaRequestHeader) {
      // throw 400
      return response.badRequest({
        body: `uri [${request.url}] with method [${request.route.method}] exists but is not available with the current configuration`
      });
    }
    return toolkit.next();
  };
};
exports.createRestrictInternalRoutesPostAuthHandler = createRestrictInternalRoutesPostAuthHandler;
const createVersionCheckPostAuthHandler = kibanaVersion => {
  return (request, response, toolkit) => {
    const requestVersion = request.headers[VERSION_HEADER];
    if (requestVersion && requestVersion !== kibanaVersion) {
      return response.badRequest({
        body: {
          message: `Browser client is out of date, please refresh the page ` + `("${VERSION_HEADER}" header was "${requestVersion}" but should be "${kibanaVersion}")`,
          attributes: {
            expected: kibanaVersion,
            got: requestVersion
          }
        }
      });
    }
    return toolkit.next();
  };
};
exports.createVersionCheckPostAuthHandler = createVersionCheckPostAuthHandler;
const createCustomHeadersPreResponseHandler = config => {
  const {
    name: serverName,
    securityResponseHeaders,
    customResponseHeaders,
    csp: {
      header: cspHeader
    }
  } = config;
  return (request, response, toolkit) => {
    const additionalHeaders = {
      ...securityResponseHeaders,
      ...customResponseHeaders,
      'Content-Security-Policy': cspHeader,
      [KIBANA_NAME_HEADER]: serverName
    };
    return toolkit.next({
      headers: additionalHeaders
    });
  };
};
exports.createCustomHeadersPreResponseHandler = createCustomHeadersPreResponseHandler;