"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeSliderControl = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _range_slider_embeddable = require("../embeddable/range_slider_embeddable");
var _range_slider_popover = require("./range_slider_popover");
var _control_error_component = require("../../control_group/component/control_error_component");
var _range_slider_button = require("./range_slider_button");
require("./range_slider.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RangeSliderControl = () => {
  const rangeRef = (0, _react.useRef)(null);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const rangeSlider = (0, _range_slider_embeddable.useRangeSlider)();
  const error = rangeSlider.select(state => state.componentState.error);
  const value = rangeSlider.select(state => state.explicitInput.value);
  const [displayedValue, setDisplayedValue] = (0, _react.useState)(value !== null && value !== void 0 ? value : ['', '']);
  const debouncedOnChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(newRange => {
    rangeSlider.dispatch.setSelectedRange(newRange);
  }, 750), [rangeSlider.dispatch]);
  (0, _react.useEffect)(() => {
    debouncedOnChange(displayedValue);
  }, [debouncedOnChange, displayedValue]);
  (0, _react.useEffect)(() => {
    setDisplayedValue(value !== null && value !== void 0 ? value : ['', '']);
  }, [value]);
  const button = /*#__PURE__*/_react.default.createElement(_range_slider_button.RangeSliderButton, {
    value: displayedValue,
    onChange: setDisplayedValue,
    isPopoverOpen: isPopoverOpen,
    setIsPopoverOpen: setIsPopoverOpen
  });
  return error ? /*#__PURE__*/_react.default.createElement(_control_error_component.ControlError, {
    error: error
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    input: button,
    isOpen: isPopoverOpen,
    display: "block",
    panelPaddingSize: "s",
    className: "rangeSlider__popoverOverride",
    anchorClassName: "rangeSlider__anchorOverride",
    panelClassName: "rangeSlider__panelOverride",
    closePopover: () => {
      setIsPopoverOpen(false);
    },
    anchorPosition: "downCenter",
    attachToAnchor: false,
    disableFocusTrap: true,
    onPanelResize: width => {
      var _rangeRef$current;
      (_rangeRef$current = rangeRef.current) === null || _rangeRef$current === void 0 ? void 0 : _rangeRef$current.onResize(width);
    }
  }, /*#__PURE__*/_react.default.createElement(_range_slider_popover.RangeSliderPopover, {
    rangeRef: rangeRef,
    value: displayedValue,
    onChange: setDisplayedValue
  }));
};
exports.RangeSliderControl = RangeSliderControl;