"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _options_list_strings = require("./options_list_strings");
var _options_list_embeddable = require("../embeddable/options_list_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListPopoverTitle = () => {
  const optionsList = (0, _options_list_embeddable.useOptionsList)();
  const allowExpensiveQueries = optionsList.select(state => state.componentState.allowExpensiveQueries);
  const title = optionsList.select(state => state.explicitInput.title);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, title), !allowExpensiveQueries && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "optionsList-allow-expensive-queries-warning",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": "Warning",
    type: "warning",
    color: "warning",
    content: _options_list_strings.OptionsListStrings.popover.getAllowExpensiveQueriesWarning()
  }))));
};
exports.OptionsListPopoverTitle = OptionsListPopoverTitle;