"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverEmptyMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _options_list_strings = require("./options_list_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListPopoverEmptyMessage = ({
  showOnlySelected
}) => {
  return /*#__PURE__*/_react.default.createElement("span", {
    className: "euiFilterSelect__note",
    "data-test-subj": `optionsList-control-${showOnlySelected ? 'selectionsEmptyMessage' : 'noSelectionsMessage'}`
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "euiFilterSelect__noteContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minusInCircle"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), showOnlySelected ? _options_list_strings.OptionsListStrings.popover.getSelectionsEmptyMessage() : _options_list_strings.OptionsListStrings.popover.getEmptyMessage()));
};
exports.OptionsListPopoverEmptyMessage = OptionsListPopoverEmptyMessage;