"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useControlGroupContainer = exports.setFlyoutRef = exports.controlGroupSelector = exports.ControlGroupContainerContext = exports.ControlGroupContainer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _types = require("../types");
var _control_group_chaining_system = require("./control_group_chaining_system");
var _control_group_input_builder = require("../external_api/control_group_input_builder");
var _services = require("../../services");
var _control_group_helpers = require("./control_group_helpers");
var _control_group_component = require("../component/control_group_component");
var _control_group_reducers = require("../state/control_group_reducers");
var _open_add_data_control_flyout = require("../editor/open_add_data_control_flyout");
var _open_edit_control_group_flyout = require("../editor/open_edit_control_group_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let flyoutRef;
const setFlyoutRef = newRef => {
  flyoutRef = newRef;
};
exports.setFlyoutRef = setFlyoutRef;
const ControlGroupContainerContext = /*#__PURE__*/(0, _react.createContext)(null);
exports.ControlGroupContainerContext = ControlGroupContainerContext;
const controlGroupSelector = _reactRedux.useSelector;
exports.controlGroupSelector = controlGroupSelector;
const useControlGroupContainer = () => {
  const controlGroup = (0, _react.useContext)(ControlGroupContainerContext);
  if (controlGroup == null) {
    throw new Error('useControlGroupContainer must be used inside ControlGroupContainerContext.');
  }
  return controlGroup;
};
exports.useControlGroupContainer = useControlGroupContainer;
class ControlGroupContainer extends _public2.Container {
  // state management

  constructor(reduxToolsPackage, initialInput, parent, settings, fieldFilterPredicate) {
    var _ControlGroupChaining;
    super(initialInput, {
      dataViewIds: [],
      embeddableLoaded: {},
      filters: []
    }, _services.pluginServices.getServices().controls.getControlFactory, parent, (_ControlGroupChaining = _control_group_chaining_system.ControlGroupChainingSystems[initialInput.chainingSystem]) === null || _ControlGroupChaining === void 0 ? void 0 : _ControlGroupChaining.getContainerSettings(initialInput));
    (0, _defineProperty2.default)(this, "type", _types.CONTROL_GROUP_TYPE);
    (0, _defineProperty2.default)(this, "anyControlOutputConsumerLoading$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "initialized$", new _rxjs.BehaviorSubject(false));
    (0, _defineProperty2.default)(this, "subscriptions", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "domNode", void 0);
    (0, _defineProperty2.default)(this, "recalculateFilters$", void 0);
    (0, _defineProperty2.default)(this, "relevantDataViewId", void 0);
    (0, _defineProperty2.default)(this, "lastUsedDataViewId", void 0);
    (0, _defineProperty2.default)(this, "select", void 0);
    (0, _defineProperty2.default)(this, "getState", void 0);
    (0, _defineProperty2.default)(this, "dispatch", void 0);
    (0, _defineProperty2.default)(this, "onStateChange", void 0);
    (0, _defineProperty2.default)(this, "store", void 0);
    (0, _defineProperty2.default)(this, "cleanupStateTools", void 0);
    (0, _defineProperty2.default)(this, "onFiltersPublished$", void 0);
    (0, _defineProperty2.default)(this, "onControlRemoved$", void 0);
    (0, _defineProperty2.default)(this, "fieldFilterPredicate", void 0);
    (0, _defineProperty2.default)(this, "setupSubscriptions", () => {
      /**
       * refresh control order cache and make all panels refreshInputFromParent whenever panel orders change
       */
      this.subscriptions.add(this.getInput$().pipe((0, _operators.skip)(1), (0, _operators.distinctUntilChanged)((a, b) => (0, _control_group_chaining_system.controlOrdersAreEqual)(a.panels, b.panels))).subscribe(input => {
        this.recalculateDataViews();
        this.recalculateFilters();
        const childOrderCache = (0, _control_group_chaining_system.cachedChildEmbeddableOrder)(input.panels);
        childOrderCache.idsInOrder.forEach(id => {
          var _this$getChild;
          return (_this$getChild = this.getChild(id)) === null || _this$getChild === void 0 ? void 0 : _this$getChild.refreshInputFromParent();
        });
      }));

      /**
       * run OnChildOutputChanged when any child's output has changed
       */
      this.subscriptions.add(this.getAnyChildOutputChange$().subscribe(childOutputChangedId => {
        this.recalculateDataViews();
        _control_group_chaining_system.ControlGroupChainingSystems[this.getInput().chainingSystem].onChildChange({
          childOutputChangedId,
          childOrder: (0, _control_group_chaining_system.cachedChildEmbeddableOrder)(this.getInput().panels),
          getChild: id => this.getChild(id),
          recalculateFilters$: this.recalculateFilters$
        });
      }));

      /**
       * debounce output recalculation
       */
      this.subscriptions.add(this.recalculateFilters$.pipe((0, _operators.debounceTime)(10)).subscribe(() => this.recalculateFilters()));
    });
    (0, _defineProperty2.default)(this, "updateInputAndReinitialize", newInput => {
      this.subscriptions.unsubscribe();
      this.subscriptions = new _rxjs.Subscription();
      this.initialized$.next(false);
      this.updateInput(newInput);
      this.untilAllChildrenReady().then(() => {
        this.recalculateDataViews();
        this.recalculateFilters();
        this.setupSubscriptions();
        this.initialized$.next(true);
      });
    });
    (0, _defineProperty2.default)(this, "setLastUsedDataViewId", lastUsedDataViewId => {
      this.lastUsedDataViewId = lastUsedDataViewId;
    });
    (0, _defineProperty2.default)(this, "setRelevantDataViewId", newRelevantDataViewId => {
      this.relevantDataViewId = newRelevantDataViewId;
    });
    (0, _defineProperty2.default)(this, "getMostRelevantDataViewId", () => {
      var _this$lastUsedDataVie;
      return (_this$lastUsedDataVie = this.lastUsedDataViewId) !== null && _this$lastUsedDataVie !== void 0 ? _this$lastUsedDataVie : this.relevantDataViewId;
    });
    (0, _defineProperty2.default)(this, "openAddDataControlFlyout", _open_add_data_control_flyout.openAddDataControlFlyout);
    (0, _defineProperty2.default)(this, "openEditControlGroupFlyout", _open_edit_control_group_flyout.openEditControlGroupFlyout);
    (0, _defineProperty2.default)(this, "getPanelCount", () => {
      return Object.keys(this.getInput().panels).length;
    });
    (0, _defineProperty2.default)(this, "updateFilterContext", filters => {
      this.updateInput({
        filters
      });
    });
    (0, _defineProperty2.default)(this, "recalculateFilters", () => {
      var _this$output$filters;
      const allFilters = [];
      let timeslice;
      Object.values(this.children).map(child => {
        var _childOutput$filters;
        const childOutput = child.getOutput();
        allFilters.push(...((_childOutput$filters = childOutput === null || childOutput === void 0 ? void 0 : childOutput.filters) !== null && _childOutput$filters !== void 0 ? _childOutput$filters : []));
        if (childOutput.timeslice) {
          timeslice = childOutput.timeslice;
        }
      });
      // if filters are different, publish them
      if (!(0, _esQuery.compareFilters)((_this$output$filters = this.output.filters) !== null && _this$output$filters !== void 0 ? _this$output$filters : [], allFilters !== null && allFilters !== void 0 ? allFilters : [], _esQuery.COMPARE_ALL_OPTIONS) || !(0, _lodash.isEqual)(this.output.timeslice, timeslice)) {
        this.updateOutput({
          filters: (0, _esQuery.uniqFilters)(allFilters),
          timeslice
        });
        this.onFiltersPublished$.next(allFilters);
      }
    });
    (0, _defineProperty2.default)(this, "recalculateDataViews", () => {
      const allDataViewIds = new Set();
      Object.values(this.children).map(child => {
        const dataViewId = child.getOutput().dataViewId;
        if (dataViewId) allDataViewIds.add(dataViewId);
      });
      this.updateOutput({
        dataViewIds: Array.from(allDataViewIds)
      });
    });
    (0, _defineProperty2.default)(this, "untilAllChildrenReady", () => {
      const panelsLoading = () => Object.keys(this.getInput().panels).some(panelId => !this.getOutput().embeddableLoaded[panelId]);
      if (panelsLoading()) {
        return new Promise((resolve, reject) => {
          const subscription = (0, _rxjs.merge)(this.getOutput$(), this.getInput$()).subscribe(() => {
            if (this.destroyed) {
              subscription.unsubscribe();
              reject();
            }
            if (!panelsLoading()) {
              subscription.unsubscribe();
              resolve();
            }
          });
        });
      }
      return Promise.resolve();
    });
    (0, _defineProperty2.default)(this, "untilInitialized", () => {
      if (this.initialized$.value === false) {
        return new Promise((resolve, reject) => {
          const subscription = this.initialized$.subscribe(isInitialized => {
            if (this.destroyed) {
              subscription.unsubscribe();
              reject();
            }
            if (isInitialized) {
              subscription.unsubscribe();
              resolve();
            }
          });
        });
      }
      return Promise.resolve();
    });
    this.recalculateFilters$ = new _rxjs.Subject();
    this.onFiltersPublished$ = new _rxjs.Subject();
    this.onControlRemoved$ = new _rxjs.Subject();

    // build redux embeddable tools
    const reduxEmbeddableTools = reduxToolsPackage.createReduxEmbeddableTools({
      embeddable: this,
      reducers: _control_group_reducers.controlGroupReducers,
      initialComponentState: settings
    });
    this.select = reduxEmbeddableTools.select;
    this.getState = reduxEmbeddableTools.getState;
    this.dispatch = reduxEmbeddableTools.dispatch;
    this.cleanupStateTools = reduxEmbeddableTools.cleanup;
    this.onStateChange = reduxEmbeddableTools.onStateChange;
    this.store = reduxEmbeddableTools.store;

    // when all children are ready setup subscriptions
    this.untilAllChildrenReady().then(() => {
      this.recalculateDataViews();
      this.recalculateFilters();
      this.setupSubscriptions();
      this.initialized$.next(true);
    });
    this.fieldFilterPredicate = fieldFilterPredicate;
  }
  closeAllFlyouts() {
    var _flyoutRef;
    (_flyoutRef = flyoutRef) === null || _flyoutRef === void 0 ? void 0 : _flyoutRef.close();
    flyoutRef = undefined;
  }
  async addDataControlFromField(controlProps) {
    const panelState = await (0, _control_group_input_builder.getDataControlPanelState)(this.getInput(), controlProps);
    return this.createAndSaveEmbeddable(panelState.type, panelState);
  }
  addOptionsListControl(controlProps) {
    const panelState = (0, _control_group_input_builder.getOptionsListPanelState)(this.getInput(), controlProps);
    return this.createAndSaveEmbeddable(panelState.type, panelState);
  }
  addRangeSliderControl(controlProps) {
    const panelState = (0, _control_group_input_builder.getRangeSliderPanelState)(this.getInput(), controlProps);
    return this.createAndSaveEmbeddable(panelState.type, panelState);
  }
  addTimeSliderControl() {
    const panelState = (0, _control_group_input_builder.getTimeSliderPanelState)(this.getInput());
    return this.createAndSaveEmbeddable(panelState.type, panelState);
  }
  createNewPanelState(factory, partial = {}) {
    const panelState = super.createNewPanelState(factory, partial);
    return {
      order: (0, _control_group_helpers.getNextPanelOrder)(this.getInput().panels),
      width: this.getInput().defaultControlWidth,
      grow: this.getInput().defaultControlGrow,
      ...panelState
    };
  }
  onRemoveEmbeddable(idToRemove) {
    const newPanels = super.onRemoveEmbeddable(idToRemove);
    const childOrderCache = (0, _control_group_chaining_system.cachedChildEmbeddableOrder)(this.getInput().panels);
    const removedOrder = childOrderCache.IdsToOrder[idToRemove];
    for (let i = removedOrder + 1; i < childOrderCache.idsInOrder.length; i++) {
      const currentOrder = newPanels[childOrderCache.idsInOrder[i]].order;
      newPanels[childOrderCache.idsInOrder[i]] = {
        ...newPanels[childOrderCache.idsInOrder[i]],
        order: currentOrder - 1
      };
    }
    this.onControlRemoved$.next(idToRemove);
    return newPanels;
  }
  getInheritedInput(id) {
    var _precedingFilters$fil;
    const {
      filters,
      query,
      ignoreParentSettings,
      timeRange,
      chainingSystem,
      panels
    } = this.getInput();
    const precedingFilters = _control_group_chaining_system.ControlGroupChainingSystems[chainingSystem].getPrecedingFilters({
      id,
      childOrder: (0, _control_group_chaining_system.cachedChildEmbeddableOrder)(panels),
      getChild: getChildId => this.getChild(getChildId)
    });
    const allFilters = [...(ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreFilters ? [] : filters !== null && filters !== void 0 ? filters : []), ...((_precedingFilters$fil = precedingFilters === null || precedingFilters === void 0 ? void 0 : precedingFilters.filters) !== null && _precedingFilters$fil !== void 0 ? _precedingFilters$fil : [])];
    return {
      ignoreParentSettings,
      filters: allFilters,
      query: ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreQuery ? undefined : query,
      timeRange: ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreTimerange ? undefined : timeRange,
      timeslice: ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreTimerange ? undefined : precedingFilters === null || precedingFilters === void 0 ? void 0 : precedingFilters.timeslice,
      id
    };
  }
  render(dom) {
    if (this.domNode) {
      _reactDom.default.unmountComponentAtNode(this.domNode);
    }
    this.domNode = dom;
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: _services.pluginServices.getServices().theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
      store: this.store
    }, /*#__PURE__*/_react.default.createElement(ControlGroupContainerContext.Provider, {
      value: this
    }, /*#__PURE__*/_react.default.createElement(_control_group_component.ControlGroup, null)))), dom);
  }
  destroy() {
    super.destroy();
    this.closeAllFlyouts();
    this.subscriptions.unsubscribe();
    this.cleanupStateTools();
    if (this.domNode) _reactDom.default.unmountComponentAtNode(this.domNode);
  }
}
exports.ControlGroupContainer = ControlGroupContainer;