"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCompatibleSortingTypes = exports.OPTIONS_LIST_DEFAULT_SORT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OPTIONS_LIST_DEFAULT_SORT = {
  by: '_count',
  direction: 'desc'
};
exports.OPTIONS_LIST_DEFAULT_SORT = OPTIONS_LIST_DEFAULT_SORT;
const getCompatibleSortingTypes = type => {
  switch (type) {
    case 'ip':
      {
        return ['_count'];
      }
    default:
      {
        return ['_count', '_key'];
      }
  }
};
exports.getCompatibleSortingTypes = getCompatibleSortingTypes;