"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeAutocompleteComponent = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _list_component = require("./list_component");
var _autocomplete_entities = require("../../autocomplete_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function TypeGenerator(context) {
  return (0, _autocomplete_entities.getTypes)(context.indices);
}
function nonValidIndexType(token) {
  return !(token === '_all' || token[0] !== '_');
}
class TypeAutocompleteComponent extends _list_component.ListComponent {
  constructor(name, parent, multiValued) {
    super(name, TypeGenerator, parent, multiValued);
  }
  validateTokens(tokens) {
    if (!this.multiValued && tokens.length > 1) {
      return false;
    }
    return !_lodash.default.find(tokens, nonValidIndexType);
  }
  getDefaultTermMeta() {
    return 'type';
  }
  getContextKey() {
    return 'types';
  }
}
exports.TypeAutocompleteComponent = TypeAutocompleteComponent;