"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = exports.initialValue = void 0;
var _immer = require("immer");
var _function = require("fp-ts/lib/function");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const initialValue = (0, _immer.produce)({
  ready: false,
  settings: _services.DEFAULT_SETTINGS,
  currentTextObject: null
}, _function.identity);
exports.initialValue = initialValue;
const reducer = (state, action) => (0, _immer.produce)(state, draft => {
  if (action.type === 'setInputEditor') {
    if (action.payload) {
      draft.ready = true;
    }
    return;
  }
  if (action.type === 'updateSettings') {
    draft.settings = action.payload;
    return;
  }
  if (action.type === 'setCurrentTextObject') {
    draft.currentTextObject = action.payload;
    return;
  }
  return draft;
});
exports.reducer = reducer;