"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRawConfigServiceMock = exports.createMockedContext = void 0;
exports.getEnvOptions = getEnvOptions;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getEnvOptions(options = {}) {
  return {
    configs: options.configs || [],
    cliArgs: {
      dev: true,
      silent: false,
      watch: false,
      basePath: false,
      disableOptimizer: true,
      cache: true,
      dist: false,
      oss: false,
      runExamples: false,
      ...(options.cliArgs || {})
    },
    repoPackages: options.repoPackages
  };
}
const createMockedContext = () => {
  return {
    branch: 'master',
    version: '8.0.0',
    docLinks: {}
  };
};
exports.createMockedContext = createMockedContext;
const createRawConfigServiceMock = ({
  rawConfig = {},
  rawConfig$ = undefined
} = {}) => {
  const mocked = {
    loadConfig: jest.fn(),
    stop: jest.fn(),
    reloadConfig: jest.fn(),
    getConfig$: jest.fn().mockReturnValue(rawConfig$ || (0, _rxjs.of)(rawConfig))
  };
  return mocked;
};
exports.createRawConfigServiceMock = createRawConfigServiceMock;