"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineGetVulnerabilitiesDashboardRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _get_vulnerabilities_trend = require("./get_vulnerabilities_trend");
var _constants = require("../../../common/constants");
var _get_safe_vulnerabilities_query_filter = require("../../../common/utils/get_safe_vulnerabilities_query_filter");
var _get_vulnerabilities_statistics = require("./get_vulnerabilities_statistics");
var _get_top_vulnerable_resources = require("./get_top_vulnerable_resources");
var _get_top_patchable_vulnerabilities = require("./get_top_patchable_vulnerabilities");
var _get_top_vulnerabilities = require("./get_top_vulnerabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defineGetVulnerabilitiesDashboardRoute = router => router.get({
  path: _constants.VULNERABILITIES_DASHBOARD_ROUTE_PATH,
  validate: false,
  options: {
    tags: ['access:cloud-security-posture-read']
  }
}, async (context, request, response) => {
  const cspContext = await context.csp;
  try {
    const esClient = cspContext.esClient.asCurrentUser;
    const query = (0, _get_safe_vulnerabilities_query_filter.getSafeVulnerabilitiesQueryFilter)();
    const [cnvmStatistics, vulnTrends, topVulnerableResources, topPatchableVulnerabilities, topVulnerabilities] = await Promise.all([(0, _get_vulnerabilities_statistics.getVulnerabilitiesStatistics)(esClient, query), (0, _get_vulnerabilities_trend.getVulnerabilitiesTrends)(esClient), (0, _get_top_vulnerable_resources.getTopVulnerableResources)(esClient, query), (0, _get_top_patchable_vulnerabilities.getTopPatchableVulnerabilities)(esClient, query), (0, _get_top_vulnerabilities.getTopVulnerabilities)(esClient, query)]);
    const body = {
      cnvmStatistics,
      vulnTrends,
      topVulnerableResources,
      topPatchableVulnerabilities,
      topVulnerabilities
    };
    return response.ok({
      body
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Error while fetching Vulnerabilities stats: ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineGetVulnerabilitiesDashboardRoute = defineGetVulnerabilitiesDashboardRoute;