"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityDashboard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_vulnerability_dashboard_api = require("../../common/api/use_vulnerability_dashboard_api");
var _vulnerability_trend_graph = require("./vulnerability_trend_graph");
var _use_setup_status_api = require("../../common/api/use_setup_status_api");
var _no_vulnerabilities_states = require("../../components/no_vulnerabilities_states");
var _test_subjects = require("../compliance_dashboard/test_subjects");
var _vulnerability_statistics = require("./vulnerability_statistics");
var _cloud_posture_page_title = require("../../components/cloud_posture_page_title");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _vulnerability_table_panel_section = require("./vulnerability_table_panel_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VulnerabilityDashboard = () => {
  var _getSetupStatus$data, _getSetupStatus$data$;
  const getSetupStatus = (0, _use_setup_status_api.useCspSetupStatusApi)();
  const getVulnerabilityDashboard = (0, _use_vulnerability_dashboard_api.useVulnerabilityDashboardApi)();
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: getSetupStatus
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": _test_subjects.VULNERABILITY_DASHBOARD_PAGE_HEADER,
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_cloud_posture_page_title.CloudPosturePageTitle, {
      isBeta: true,
      title: _i18n.i18n.translate('xpack.csp.vulnerability_dashboard.cspPageTemplate.pageTitle', {
        defaultMessage: 'Cloud Native Vulnerability Management'
      })
    })
  }), (getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$data = getSetupStatus.data) === null || _getSetupStatus$data === void 0 ? void 0 : (_getSetupStatus$data$ = _getSetupStatus$data.vuln_mgmt) === null || _getSetupStatus$data$ === void 0 ? void 0 : _getSetupStatus$data$.status) !== 'indexed' ? /*#__PURE__*/_react.default.createElement(_no_vulnerabilities_states.NoVulnerabilitiesStates, null) : /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: getVulnerabilityDashboard
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_subjects.VULNERABILITY_DASHBOARD_CONTAINER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_vulnerability_statistics.VulnerabilityStatistics, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_vulnerability_trend_graph.VulnerabilityTrendGraph, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_vulnerability_table_panel_section.VulnerabilityTablePanelSection, null))));
};
exports.VulnerabilityDashboard = VulnerabilityDashboard;