"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTableHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesTableHeader = ({
  search,
  searchValue,
  isSearching,
  totalRulesCount,
  pageSize
}) => /*#__PURE__*/_react.default.createElement(SearchField, {
  isSearching: isSearching,
  searchValue: searchValue,
  search: search,
  totalRulesCount: totalRulesCount,
  pageSize: pageSize
});
exports.RulesTableHeader = RulesTableHeader;
const SEARCH_DEBOUNCE_MS = 300;
const SearchField = ({
  search,
  isSearching,
  searchValue,
  totalRulesCount,
  pageSize
}) => {
  const [localValue, setLocalValue] = (0, _react.useState)(searchValue);
  (0, _useDebounce.default)(() => search(localValue), SEARCH_DEBOUNCE_MS, [localValue]);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      alignItems: 'flex-end'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    isLoading: isSearching,
    placeholder: _i18n.i18n.translate('xpack.csp.rules.rulesTable.searchPlaceholder', {
      defaultMessage: 'Search by Rule Name'
    }),
    value: localValue,
    onChange: e => setLocalValue(e.target.value),
    style: {
      minWidth: 150
    },
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(CurrentPageOfTotal, {
    pageSize: pageSize,
    total: totalRulesCount
  }));
};
const CurrentPageOfTotal = ({
  pageSize,
  total
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xl"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  textAlign: "left",
  color: "subdued",
  style: {
    marginLeft: '8px'
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.rules.rulesTable.showingPageOfTotalLabel",
  defaultMessage: "Showing {pageSize} of of {total, plural, one {# rule} other {# rules}}",
  values: {
    pageSize,
    total
  }
})));