"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExpandColumn = exports.createColumnWithFilters = exports.baseFindingsColumns = exports.PageTitleText = exports.PageTitle = exports.LimitedResultsBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
var _timestamp_table_cell = require("../../../components/timestamp_table_cell");
var _column_name_with_tooltip = require("../../../components/column_name_with_tooltip");
var _csp_evaluation_badge = require("../../../components/csp_evaluation_badge");
var _test_subjects = require("../test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PageTitle = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "l"
}, /*#__PURE__*/_react.default.createElement("div", null, children));
exports.PageTitle = PageTitle;
const PageTitleText = ({
  title
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  grow: false,
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h1", null, title));
exports.PageTitleText = PageTitleText;
const getExpandColumn = ({
  onClick
}) => ({
  width: '40px',
  actions: [{
    'data-test-subj': _test_subjects.FINDINGS_TABLE_EXPAND_COLUMN,
    name: _i18n.i18n.translate('xpack.csp.expandColumnNameLabel', {
      defaultMessage: 'Expand'
    }),
    description: _i18n.i18n.translate('xpack.csp.expandColumnDescriptionLabel', {
      defaultMessage: 'Expand'
    }),
    type: 'icon',
    icon: 'expand',
    onClick
  }]
});
exports.getExpandColumn = getExpandColumn;
const baseColumns = [{
  field: 'resource.id',
  name: /*#__PURE__*/_react.default.createElement(_column_name_with_tooltip.ColumnNameWithTooltip, {
    columnName: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.resourceIdColumnLabel', {
      defaultMessage: 'Resource ID'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.resourceIdColumnTooltipLabel', {
      defaultMessage: 'Custom Elastic Resource ID'
    })
  }),
  truncateText: true,
  width: '180px',
  sortable: true,
  render: filename => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: filename,
    anchorClassName: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement("span", null, filename))
}, {
  field: 'result.evaluation',
  name: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.resultColumnLabel', {
    defaultMessage: 'Result'
  }),
  width: '80px',
  sortable: true,
  render: type => /*#__PURE__*/_react.default.createElement(_csp_evaluation_badge.CspEvaluationBadge, {
    type: type
  })
}, {
  field: 'resource.sub_type',
  name: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.resourceTypeColumnLabel', {
    defaultMessage: 'Resource Type'
  }),
  sortable: true,
  truncateText: true,
  width: '10%'
}, {
  field: 'resource.name',
  name: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.resourceNameColumnLabel', {
    defaultMessage: 'Resource Name'
  }),
  sortable: true,
  truncateText: true,
  width: '12%',
  render: name => {
    if (!name) return;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: name,
      position: "left",
      anchorClassName: "eui-textTruncate"
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, name));
  }
}, {
  field: 'rule.name',
  name: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.ruleNameColumnLabel', {
    defaultMessage: 'Rule Name'
  }),
  sortable: true,
  render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: name,
    position: "left",
    anchorClassName: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, name))
}, {
  field: 'rule.benchmark.rule_number',
  name: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.ruleNumberColumnLabel', {
    defaultMessage: 'Rule Number'
  }),
  sortable: true,
  width: '120px'
}, {
  field: 'rule.benchmark.name',
  name: /*#__PURE__*/_react.default.createElement(_column_name_with_tooltip.ColumnNameWithTooltip, {
    columnName: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.ruleBenchmarkColumnLabel', {
      defaultMessage: 'Applicable Benchmark'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.ruleBenchmarkColumnTooltipLabel', {
      defaultMessage: 'The benchmark(s) rules used to evaluate this resource came from'
    })
  }),
  sortable: true,
  truncateText: true
}, {
  field: 'rule.section',
  name: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.ruleSectionColumnLabel', {
    defaultMessage: 'CIS Section'
  }),
  width: '150px',
  sortable: true,
  truncateText: true,
  render: section => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: section,
    anchorClassName: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, section))
}, {
  field: '@timestamp',
  align: 'right',
  width: '10%',
  name: _i18n.i18n.translate('xpack.csp.findings.findingsTable.findingsTableColumn.lastCheckedColumnLabel', {
    defaultMessage: 'Last Checked'
  }),
  truncateText: true,
  sortable: true,
  render: timestamp => /*#__PURE__*/_react.default.createElement(_timestamp_table_cell.TimestampTableCell, {
    timestamp: timestamp
  })
}];
const baseFindingsColumns = Object.fromEntries(baseColumns.map(column => [column.field, column]));
exports.baseFindingsColumns = baseFindingsColumns;
const createColumnWithFilters = (column, {
  onAddFilter
}) => ({
  ...column,
  render: (cellValue, item) => {
    var _column$render;
    return /*#__PURE__*/_react.default.createElement(FilterableCell, {
      onAddFilter: () => onAddFilter(column.field, cellValue, false),
      onAddNegateFilter: () => onAddFilter(column.field, cellValue, true),
      field: column.field
    }, ((_column$render = column.render) === null || _column$render === void 0 ? void 0 : _column$render.call(column, cellValue, item)) || getCellValue(cellValue));
  }
});
exports.createColumnWithFilters = createColumnWithFilters;
const getCellValue = value => {
  if (!value) return;
  if (typeof value === 'string' || typeof value === 'number') return value;
};
const FilterableCell = ({
  children,
  onAddFilter,
  onAddNegateFilter,
  field
}) => /*#__PURE__*/_react.default.createElement("div", {
  css: (0, _react2.css)`
      position: relative;
      width: 100%;

      &:hover {
        > .__filter_buttons {
          opacity: 1;
        }
        > .__filter_value {
          max-width: calc(100% - calc(${_uiTheme.euiThemeVars.euiSizeL} * 2));
        }
      }
    `
}, /*#__PURE__*/_react.default.createElement("div", {
  className: "__filter_value eui-textTruncate",
  "data-test-subj": "filter_cell_value"
}, children), /*#__PURE__*/_react.default.createElement("div", {
  className: "__filter_buttons",
  css: (0, _react2.css)`
        opacity: 0;
        position: absolute;
        right: 0;
        top: 0;
        display: flex;
      `
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: _i18n.i18n.translate('xpack.csp.findings.findingsTableCell.addFilterButtonTooltip', {
    defaultMessage: 'Add {field} filter',
    values: {
      field
    }
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  iconType: "plusInCircleFilled",
  onClick: onAddFilter,
  "data-test-subj": _test_subjects.FINDINGS_TABLE_CELL_ADD_FILTER,
  "aria-label": _i18n.i18n.translate('xpack.csp.findings.findingsTableCell.addFilterButton', {
    defaultMessage: 'Add {field} filter',
    values: {
      field
    }
  })
})), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: _i18n.i18n.translate('xpack.csp.findings.findingsTableCell.addNegatedFilterButtonTooltip', {
    defaultMessage: 'Add {field} negated filter',
    values: {
      field
    }
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  iconType: "minusInCircleFilled",
  onClick: onAddNegateFilter,
  "data-test-subj": _test_subjects.FINDINGS_TABLE_CELL_ADD_NEGATED_FILTER,
  "aria-label": _i18n.i18n.translate('xpack.csp.findings.findingsTableCell.addNegateFilterButton', {
    defaultMessage: 'Add {field} negated filter',
    values: {
      field
    }
  })
}))));
const LimitedResultsBar = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xxl"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
  "data-test-subj": "test-bottom-bar"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  textAlign: "center"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.findings..bottomBarLabel",
  defaultMessage: "These are the first {maxItems} findings matching your search, refine your search to see others.",
  values: {
    maxItems: _constants.MAX_FINDINGS_TO_LOAD
  }
}))));
exports.LimitedResultsBar = LimitedResultsBar;