"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComplianceDashboard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _test_subjects = require("../../components/test_subjects");
var _use_csp_integration_link = require("../../common/navigation/use_csp_integration_link");
var _cloud_posture_page_title = require("../../components/cloud_posture_page_title");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _test_subjects2 = require("./test_subjects");
var _use_stats_api = require("../../common/api/use_stats_api");
var _use_setup_status_api = require("../../common/api/use_setup_status_api");
var _no_findings_states = require("../../components/no_findings_states");
var _summary_section = require("./dashboard_sections/summary_section");
var _benchmarks_section = require("./dashboard_sections/benchmarks_section");
var _constants = require("../../../common/constants");
var _constants2 = require("../../common/navigation/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const noDataOptions = {
  kspm: {
    testId: _cloud_posture_page.KSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT,
    docsLink: _constants2.cspIntegrationDocsNavigation.kspm.overviewPath,
    actionTitle: _i18n.i18n.translate('xpack.csp.cloudPosturePage.kspmIntegration.packageNotInstalled.buttonLabel', {
      defaultMessage: 'Add a KSPM integration'
    }),
    actionDescription: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.kspmIntegration.packageNotInstalled.description",
      defaultMessage: "Use our {integrationFullName} (KSPM) integration to detect security misconfigurations in your Kubernetes clusters.",
      values: {
        integrationFullName: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants2.cspIntegrationDocsNavigation.kspm.overviewPath,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.cloudPosturePage.kspmIntegration.packageNotInstalled.integrationNameLabel",
          defaultMessage: "Kubernetes Security Posture Management"
        }))
      }
    })
  },
  cspm: {
    testId: _cloud_posture_page.CSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT,
    // TODO: CIS AWS - replace link or create the docs
    docsLink: _constants2.cspIntegrationDocsNavigation.cspm.overviewPath,
    actionTitle: _i18n.i18n.translate('xpack.csp.cloudPosturePage.cspmIntegration.packageNotInstalled.buttonLabel', {
      defaultMessage: 'Add a CSPM integration'
    }),
    actionDescription: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.cspmIntegration.packageNotInstalled.description",
      defaultMessage: "Use our {integrationFullName} (CSPM) integration to detect security misconfigurations in your cloud infrastructure.",
      values: {
        integrationFullName: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants2.cspIntegrationDocsNavigation.cspm.overviewPath,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.cloudPosturePage.cspmIntegration.packageNotInstalled.integrationNameLabel",
          defaultMessage: "Cloud Security Posture Management"
        }))
      }
    })
  }
};
const getNotInstalledConfig = (policyTemplate, actionHref) => {
  const policyTemplateNoDataConfig = noDataOptions[policyTemplate];
  return {
    pageTitle: _i18n.i18n.translate('xpack.csp.cloudPosturePage.packageNotInstalled.pageTitle', {
      defaultMessage: 'Install Integration to get started'
    }),
    docsLink: policyTemplateNoDataConfig.docsLink,
    actionHref,
    actionTitle: policyTemplateNoDataConfig.actionTitle,
    actionDescription: policyTemplateNoDataConfig.actionDescription,
    testId: policyTemplateNoDataConfig.testId
  };
};
const KIBANA_HEADERS_HEIGHT = 265;
const IntegrationPostureDashboard = ({
  complianceData,
  notInstalledConfig,
  isIntegrationInstalled,
  dashboardType
}) => {
  const noFindings = !complianceData || complianceData.stats.totalFindings === 0;

  // integration is not installed, and there are no findings for this integration
  if (noFindings && !isIntegrationInstalled) {
    return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CspNoDataPage, notInstalledConfig);
  }

  // integration is installed, but there are no findings for this integration
  if (noFindings && isIntegrationInstalled) {
    return (
      /*#__PURE__*/
      // height is calculated for the screen height minus the kibana header, page title, and tabs
      _react.default.createElement("div", {
        style: {
          height: `calc(100vh - ${KIBANA_HEADERS_HEIGHT}px)`,
          display: 'flex',
          justifyContent: 'center'
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        "data-test-subj": _test_subjects.NO_FINDINGS_STATUS_TEST_SUBJ.NO_FINDINGS,
        color: "plain",
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "logoSecurity",
          size: "xl"
        }),
        title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.integrationDashboard.noFindings.promptTitle",
          defaultMessage: "Findings Evaluation Status"
        })),
        body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.integrationDashboard.noFindingsPrompt.promptDescription",
          defaultMessage: "Waiting for data to be collected and indexed. If this process is taking longer than expected then please reach out our support"
        }))
      }))
    );
  }

  // there are findings, displays dashboard even if integration is not installed
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_summary_section.SummarySection, {
    complianceData: complianceData,
    dashboardType: dashboardType
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_benchmarks_section.BenchmarksSection, {
    complianceData: complianceData,
    dashboardType: dashboardType
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
const getDefaultTab = (pluginStatus, cspmStats, kspmStats) => {
  var _pluginStatus$cspm, _pluginStatus$kspm;
  const cspmTotalFindings = cspmStats === null || cspmStats === void 0 ? void 0 : cspmStats.stats.totalFindings;
  const kspmTotalFindings = kspmStats === null || kspmStats === void 0 ? void 0 : kspmStats.stats.totalFindings;
  const installedPolicyTemplatesCspm = pluginStatus === null || pluginStatus === void 0 ? void 0 : (_pluginStatus$cspm = pluginStatus.cspm) === null || _pluginStatus$cspm === void 0 ? void 0 : _pluginStatus$cspm.status;
  const installedPolicyTemplatesKspm = pluginStatus === null || pluginStatus === void 0 ? void 0 : (_pluginStatus$kspm = pluginStatus.kspm) === null || _pluginStatus$kspm === void 0 ? void 0 : _pluginStatus$kspm.status;
  let preferredDashboard = _constants.CSPM_POLICY_TEMPLATE;

  // cspm has findings
  if (!!cspmTotalFindings) {
    preferredDashboard = _constants.CSPM_POLICY_TEMPLATE;
  }
  // kspm has findings
  else if (!!kspmTotalFindings) {
    preferredDashboard = _constants.KSPM_POLICY_TEMPLATE;
  }
  // cspm is installed
  else if (installedPolicyTemplatesCspm !== 'unprivileged' && installedPolicyTemplatesCspm !== 'not-installed') {
    preferredDashboard = _constants.CSPM_POLICY_TEMPLATE;
  }
  // kspm is installed
  else if (installedPolicyTemplatesKspm !== 'unprivileged' && installedPolicyTemplatesKspm !== 'not-installed') {
    preferredDashboard = _constants.KSPM_POLICY_TEMPLATE;
  }
  return preferredDashboard;
};
const ComplianceDashboard = () => {
  var _getCspmDashboardData, _getKspmDashboardData, _getSetupStatus$cspm, _getSetupStatus$kspm, _getSetupStatus$cspm5, _getSetupStatus$kspm5, _tabs$find;
  const [selectedTab, setSelectedTab] = (0, _react.useState)(_constants.CSPM_POLICY_TEMPLATE);
  const {
    data: getSetupStatus
  } = (0, _use_setup_status_api.useCspSetupStatusApi)();
  const cspmIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_constants.CSPM_POLICY_TEMPLATE);
  const kspmIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_constants.KSPM_POLICY_TEMPLATE);
  const isCloudSecurityPostureInstalled = !!(getSetupStatus !== null && getSetupStatus !== void 0 && getSetupStatus.installedPackageVersion);
  const getCspmDashboardData = (0, _use_stats_api.useCspmStatsApi)({
    enabled: isCloudSecurityPostureInstalled
  });
  const getKspmDashboardData = (0, _use_stats_api.useKspmStatsApi)({
    enabled: isCloudSecurityPostureInstalled
  });
  (0, _react.useEffect)(() => {
    const preferredDashboard = getDefaultTab(getSetupStatus, getCspmDashboardData.data, getKspmDashboardData.data);
    setSelectedTab(preferredDashboard);
  }, [getCspmDashboardData.data, (_getCspmDashboardData = getCspmDashboardData.data) === null || _getCspmDashboardData === void 0 ? void 0 : _getCspmDashboardData.stats.totalFindings, getKspmDashboardData.data, (_getKspmDashboardData = getKspmDashboardData.data) === null || _getKspmDashboardData === void 0 ? void 0 : _getKspmDashboardData.stats.totalFindings, getSetupStatus, getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$cspm = getSetupStatus.cspm) === null || _getSetupStatus$cspm === void 0 ? void 0 : _getSetupStatus$cspm.status, getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$kspm = getSetupStatus.kspm) === null || _getSetupStatus$kspm === void 0 ? void 0 : _getSetupStatus$kspm.status]);
  const tabs = (0, _react.useMemo)(() => {
    var _getSetupStatus$cspm2, _getSetupStatus$cspm3, _getSetupStatus$cspm4, _getSetupStatus$kspm2, _getSetupStatus$kspm3, _getSetupStatus$kspm4;
    return isCloudSecurityPostureInstalled ? [{
      label: _i18n.i18n.translate('xpack.csp.dashboardTabs.cloudTab.tabTitle', {
        defaultMessage: 'Cloud'
      }),
      'data-test-subj': _test_subjects2.CLOUD_DASHBOARD_TAB,
      isSelected: selectedTab === _constants.CSPM_POLICY_TEMPLATE,
      onClick: () => setSelectedTab(_constants.CSPM_POLICY_TEMPLATE),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isCloudSecurityPostureInstalled && ((getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$cspm2 = getSetupStatus.cspm) === null || _getSetupStatus$cspm2 === void 0 ? void 0 : _getSetupStatus$cspm2.status) === 'indexed' || (getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$cspm3 = getSetupStatus.cspm) === null || _getSetupStatus$cspm3 === void 0 ? void 0 : _getSetupStatus$cspm3.status) === 'not-installed') ? /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
        query: getCspmDashboardData
      }, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": _test_subjects2.CLOUD_DASHBOARD_CONTAINER
      }, /*#__PURE__*/_react.default.createElement(IntegrationPostureDashboard, {
        dashboardType: _constants.CSPM_POLICY_TEMPLATE,
        complianceData: getCspmDashboardData.data,
        notInstalledConfig: getNotInstalledConfig(_constants.CSPM_POLICY_TEMPLATE, cspmIntegrationLink),
        isIntegrationInstalled: (getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$cspm4 = getSetupStatus.cspm) === null || _getSetupStatus$cspm4 === void 0 ? void 0 : _getSetupStatus$cspm4.status) !== 'not-installed'
      }))) : /*#__PURE__*/_react.default.createElement(_no_findings_states.NoFindingsStates, {
        posturetype: 'cspm'
      }))
    }, {
      label: _i18n.i18n.translate('xpack.csp.dashboardTabs.kubernetesTab.tabTitle', {
        defaultMessage: 'Kubernetes'
      }),
      'data-test-subj': _test_subjects2.KUBERNETES_DASHBOARD_TAB,
      isSelected: selectedTab === _constants.KSPM_POLICY_TEMPLATE,
      onClick: () => setSelectedTab(_constants.KSPM_POLICY_TEMPLATE),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isCloudSecurityPostureInstalled && ((getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$kspm2 = getSetupStatus.kspm) === null || _getSetupStatus$kspm2 === void 0 ? void 0 : _getSetupStatus$kspm2.status) === 'indexed' || (getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$kspm3 = getSetupStatus.kspm) === null || _getSetupStatus$kspm3 === void 0 ? void 0 : _getSetupStatus$kspm3.status) === 'not-installed') ? /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
        query: getKspmDashboardData
      }, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": _test_subjects2.KUBERNETES_DASHBOARD_CONTAINER
      }, /*#__PURE__*/_react.default.createElement(IntegrationPostureDashboard, {
        dashboardType: _constants.KSPM_POLICY_TEMPLATE,
        complianceData: getKspmDashboardData.data,
        notInstalledConfig: getNotInstalledConfig(_constants.KSPM_POLICY_TEMPLATE, kspmIntegrationLink),
        isIntegrationInstalled: (getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$kspm4 = getSetupStatus.kspm) === null || _getSetupStatus$kspm4 === void 0 ? void 0 : _getSetupStatus$kspm4.status) !== 'not-installed'
      }))) : /*#__PURE__*/_react.default.createElement(_no_findings_states.NoFindingsStates, {
        posturetype: 'kspm'
      }))
    }] : [];
  }, [cspmIntegrationLink, getCspmDashboardData, getKspmDashboardData, kspmIntegrationLink, selectedTab, isCloudSecurityPostureInstalled, getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$cspm5 = getSetupStatus.cspm) === null || _getSetupStatus$cspm5 === void 0 ? void 0 : _getSetupStatus$cspm5.status, getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$kspm5 = getSetupStatus.kspm) === null || _getSetupStatus$kspm5 === void 0 ? void 0 : _getSetupStatus$kspm5.status]);
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": _test_subjects2.CLOUD_POSTURE_DASHBOARD_PAGE_HEADER,
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_cloud_posture_page_title.CloudPosturePageTitle, {
      title: _i18n.i18n.translate('xpack.csp.dashboard.cspPageTemplate.pageTitle', {
        defaultMessage: 'Cloud Security Posture'
      })
    }),
    tabs: tabs.map(({
      content,
      ...rest
    }) => rest)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_subjects2.DASHBOARD_CONTAINER,
    css: (0, _react2.css)`
          margin-left: auto;
          margin-right: auto;
          height: 100%;
        `
  }, (_tabs$find = tabs.find(t => t.isSelected)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content, !isCloudSecurityPostureInstalled && /*#__PURE__*/_react.default.createElement(_no_findings_states.NoFindingsStates, {
    posturetype: 'cspm'
  })));
};
exports.ComplianceDashboard = ComplianceDashboard;