"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encodeQuery = exports.decodeQuery = void 0;
var _rison = require("@kbn/rison");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const encodeRison = v => {
  try {
    return (0, _rison.encode)(v);
  } catch (e) {
    // eslint-disable-next-line no-console
    console.error(e);
  }
};
const decodeRison = query => {
  try {
    return (0, _rison.decode)(query);
  } catch (e) {
    // eslint-disable-next-line no-console
    console.error(e);
  }
};
const QUERY_PARAM_KEY = 'cspq';
const encodeQuery = query => {
  const risonQuery = encodeRison(query);
  if (!risonQuery) return;
  return `${QUERY_PARAM_KEY}=${risonQuery}`;
};
exports.encodeQuery = encodeQuery;
const decodeQuery = search => {
  const risonQuery = new URLSearchParams(search).get(QUERY_PARAM_KEY);
  if (!risonQuery) return;
  return decodeRison(risonQuery);
};
exports.decodeQuery = decodeQuery;