"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePersistedQuery = exports.useBaseEsQuery = exports.getPaginationTableParams = exports.getPaginationQuery = exports.getDefaultQuery = void 0;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBaseQuery = ({
  dataView,
  query,
  filters
}) => {
  try {
    return {
      query: (0, _esQuery.buildEsQuery)(dataView, query, filters) // will throw for malformed query
    };
  } catch (error) {
    return {
      query: undefined,
      error: error instanceof Error ? error : new Error('Unknown Error')
    };
  }
};
const getPaginationTableParams = (params, pageSizeOptions = [10, 25, 100], showPerPageOptions = true) => ({
  ...params,
  pageSizeOptions,
  showPerPageOptions
});
exports.getPaginationTableParams = getPaginationTableParams;
const getPaginationQuery = ({
  pageIndex,
  pageSize
}) => ({
  from: pageIndex * pageSize,
  size: pageSize
});
exports.getPaginationQuery = getPaginationQuery;
const useBaseEsQuery = ({
  dataView,
  filters,
  query
}) => {
  const {
    notifications: {
      toasts
    },
    data: {
      query: {
        filterManager,
        queryString
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  const baseEsQuery = (0, _react.useMemo)(() => getBaseQuery({
    dataView,
    filters,
    query
  }), [dataView, filters, query]);

  /**
   * Sync filters with the URL query
   */
  (0, _react.useEffect)(() => {
    filterManager.setAppFilters(filters);
    queryString.setQuery(query);
  }, [filters, filterManager, queryString, query]);
  const handleMalformedQueryError = () => {
    const error = baseEsQuery.error;
    if (error) {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.csp.findings.search.queryErrorToastMessage', {
          defaultMessage: 'Query Error'
        }),
        toastLifeTimeMs: 1000 * 5
      });
    }
  };
  (0, _react.useEffect)(handleMalformedQueryError, [baseEsQuery.error, toasts]);
  return baseEsQuery;
};
exports.useBaseEsQuery = useBaseEsQuery;
const usePersistedQuery = getter => {
  const {
    data: {
      query: {
        filterManager,
        queryString
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  return (0, _react.useCallback)(() => getter({
    filters: filterManager.getAppFilters(),
    query: queryString.getQuery()
  }), [getter, filterManager, queryString]);
};
exports.usePersistedQuery = usePersistedQuery;
const getDefaultQuery = ({
  query,
  filters
}) => ({
  query,
  filters,
  sort: {
    field: '@timestamp',
    direction: 'desc'
  },
  pageIndex: 0
});
exports.getDefaultQuery = getDefaultQuery;