"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePackagePolicyList = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PACKAGE_POLICY_LIST_QUERY_KEY = ['packagePolicyList'];
const usePackagePolicyList = (packageInfoName, {
  enabled = true
}) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const query = (0, _reactQuery.useQuery)(PACKAGE_POLICY_LIST_QUERY_KEY, async () => {
    try {
      const res = await http.get(_common.packagePolicyRouteService.getListPath(), {
        query: {
          perPage: _common.SO_SEARCH_LIMIT,
          page: 1,
          kuery: `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${packageInfoName}`
        }
      });
      return res;
    } catch (error) {
      throw new Error(`Failed to fetch package policy list: ${error.message}`);
    }
  }, {
    enabled,
    refetchOnMount: false,
    refetchOnWindowFocus: false
  });
  return query;
};
exports.usePackagePolicyList = usePackagePolicyList;