"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLatestFindingsDataView = void 0;
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *  TODO: use perfected kibana data views
 */
const useLatestFindingsDataView = dataView => {
  const {
    data: {
      dataViews
    }
  } = (0, _public.useKibana)().services;
  const findDataView = async () => {
    var _await$dataViews$find;
    const dataViewObj = (_await$dataViews$find = await dataViews.find(dataView)) === null || _await$dataViews$find === void 0 ? void 0 : _await$dataViews$find[0];
    if (!dataViewObj) {
      throw new Error(`Data view not found [Name: {${dataView}}]`);
    }
    return dataViewObj;
  };
  return (0, _reactQuery.useQuery)([`useDataView-${dataView}`], findDataView);
};
exports.useLatestFindingsDataView = useLatestFindingsDataView;