"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSafeVulnerabilitiesQueryFilter = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSafeVulnerabilitiesQueryFilter = query => {
  var _query$bool;
  return {
    ...query,
    bool: {
      ...(query === null || query === void 0 ? void 0 : query.bool),
      filter: [...((query === null || query === void 0 ? void 0 : (_query$bool = query.bool) === null || _query$bool === void 0 ? void 0 : _query$bool.filter) || []), {
        bool: {
          minimum_should_match: 1,
          should: [{
            match_phrase: {
              'vulnerability.severity': _constants.VULNERABILITIES_SEVERITY.CRITICAL
            }
          }, {
            match_phrase: {
              'vulnerability.severity': _constants.VULNERABILITIES_SEVERITY.HIGH
            }
          }, {
            match_phrase: {
              'vulnerability.severity': _constants.VULNERABILITIES_SEVERITY.MEDIUM
            }
          }, {
            match_phrase: {
              'vulnerability.severity': _constants.VULNERABILITIES_SEVERITY.LOW
            }
          }]
        }
      }, {
        exists: {
          field: 'vulnerability.score.base'
        }
      }, {
        exists: {
          field: 'vulnerability.score.version'
        }
      }, {
        exists: {
          field: 'vulnerability.severity'
        }
      }, {
        exists: {
          field: 'resource.id'
        }
      }, {
        exists: {
          field: 'resource.name'
        }
      }, {
        match_phrase: {
          'vulnerability.enumeration': _constants.VULNERABILITIES_ENUMERATION
        }
      }]
    }
  };
};
exports.getSafeVulnerabilitiesQueryFilter = getSafeVulnerabilitiesQueryFilter;