"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chat = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _use_chat_config = require("./use_chat_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A component that will display a trigger that will allow the user to chat with a human operator,
 * when the service is enabled; otherwise, it renders nothing.
 */
const Chat = ({
  onHide = () => {},
  onReady,
  onResize
}) => {
  const config = (0, _use_chat_config.useChatConfig)({
    onReady,
    onResize
  });
  const ref = (0, _react.useRef)(null);
  const [isClosed, setIsClosed] = (0, _react.useState)(false);
  if (!config.enabled || isClosed) {
    return null;
  }
  const {
    isReady,
    isResized,
    style
  } = config;
  const {
    right
  } = style;
  const buttonCSS = (0, _react2.css)`
    bottom: ${_uiTheme.euiThemeVars.euiSizeXS};
    position: fixed;
    right: calc(${right} + ${_uiTheme.euiThemeVars.euiSizeXS});
    visibility: ${isReady && isResized ? 'visible' : 'hidden'};
  `;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    css: buttonCSS,
    "data-test-subj": "cloud-chat-hide",
    name: "cloudChatHide",
    onClick: () => {
      onHide();
      setIsClosed(true);
    },
    size: "xs"
  }, _i18n.i18n.translate('xpack.cloudChat.hideChatButtonLabel', {
    defaultMessage: 'Hide chat'
  }));
  const containerCSS = (0, _react2.css)`
    bottom: ${_uiTheme.euiThemeVars.euiSizeXL};
    position: fixed;
    right: ${_uiTheme.euiThemeVars.euiSizeXL};
    z-index: ${_uiTheme.euiThemeVars.euiZMaskBelowHeader - 1};

    &:focus [name='cloudChatHide'],
    &:hover [name='cloudChatHide'] {
      visibility: visible;
    }
  `;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: containerCSS,
    ref: ref,
    "data-test-subj": "cloud-chat"
  }, button, /*#__PURE__*/_react.default.createElement("iframe", {
    "data-test-subj": "cloud-chat-frame",
    title: _i18n.i18n.translate('xpack.cloudChat.chatFrameTitle', {
      defaultMessage: 'Chat'
    }),
    src: config.src,
    ref: config.ref,
    style: config.style
  }));
};
exports.Chat = Chat;