"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyTransformFindResponseToExternalModel = legacyTransformFindResponseToExternalModel;
exports.transformFindResponseToExternalModel = transformFindResponseToExternalModel;
exports.transformToExternalModel = transformToExternalModel;
var _attachments = require("../../../common/utils/attachments");
var _user_actions = require("../../../common/utils/user_actions");
var _api = require("../../../common/api");
var _constants = require("../../../common/constants");
var _constants2 = require("../../common/constants");
var _transform = require("../transform");
var _type_guards = require("../type_guards");
var _so_references = require("../../attachment_framework/so_references");
var _references = require("../../common/references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformFindResponseToExternalModel(userActions, persistableStateAttachmentTypeRegistry) {
  return {
    ...userActions,
    saved_objects: userActions.saved_objects.map(so => ({
      ...so,
      ...transformToExternalModel(so, persistableStateAttachmentTypeRegistry)
    }))
  };
}
function transformToExternalModel(userAction, persistableStateAttachmentTypeRegistry) {
  var _findReferenceId;
  const {
    references
  } = userAction;
  const commentId = (_findReferenceId = (0, _references.findReferenceId)(_constants2.COMMENT_REF_NAME, _constants.CASE_COMMENT_SAVED_OBJECT, references)) !== null && _findReferenceId !== void 0 ? _findReferenceId : null;
  const payload = addReferenceIdToPayload(userAction, persistableStateAttachmentTypeRegistry);
  return {
    ...userAction,
    attributes: {
      ...userAction.attributes,
      comment_id: commentId,
      payload
    }
  };
}

/**
 * This function should only be used in the getAll user actions and it is deprecated. It should be removed when the
 * getAll route is removed.
 *
 * @deprecated remove when the getAllRoute is removed
 */
function legacyTransformFindResponseToExternalModel(userActions, persistableStateAttachmentTypeRegistry) {
  return {
    ...userActions,
    saved_objects: userActions.saved_objects.map(so => ({
      ...so,
      ...legacyTransformToExternalModel(so, persistableStateAttachmentTypeRegistry)
    }))
  };
}

/**
 * @deprecated remove when the getAll route is removed
 */
function legacyTransformToExternalModel(userAction, persistableStateAttachmentTypeRegistry) {
  var _findReferenceId2, _findReferenceId3;
  const {
    references
  } = userAction;
  const caseId = (_findReferenceId2 = (0, _references.findReferenceId)(_constants2.CASE_REF_NAME, _constants.CASE_SAVED_OBJECT, references)) !== null && _findReferenceId2 !== void 0 ? _findReferenceId2 : '';
  const commentId = (_findReferenceId3 = (0, _references.findReferenceId)(_constants2.COMMENT_REF_NAME, _constants.CASE_COMMENT_SAVED_OBJECT, references)) !== null && _findReferenceId3 !== void 0 ? _findReferenceId3 : null;
  const payload = addReferenceIdToPayload(userAction, persistableStateAttachmentTypeRegistry);
  return {
    ...userAction,
    attributes: {
      ...userAction.attributes,
      action_id: userAction.id,
      case_id: caseId,
      comment_id: commentId,
      payload
    }
  };
}
const addReferenceIdToPayload = (userAction, persistableStateAttachmentTypeRegistry) => {
  const connectorId = getConnectorIdFromReferences(userAction);
  const userActionAttributes = userAction.attributes;
  if ((0, _user_actions.isConnectorUserAction)(userActionAttributes) || (0, _user_actions.isCreateCaseUserAction)(userActionAttributes)) {
    return {
      ...userActionAttributes.payload,
      connector: {
        ...userActionAttributes.payload.connector,
        id: connectorId !== null && connectorId !== void 0 ? connectorId : _api.NONE_CONNECTOR_ID
      }
    };
  } else if ((0, _user_actions.isPushedUserAction)(userActionAttributes)) {
    return {
      ...userAction.attributes.payload,
      externalService: {
        ...userActionAttributes.payload.externalService,
        connector_id: connectorId !== null && connectorId !== void 0 ? connectorId : _api.NONE_CONNECTOR_ID
      }
    };
  } else if ((0, _user_actions.isCommentUserAction)(userActionAttributes)) {
    if ((0, _type_guards.isCommentRequestTypeExternalReferenceSO)(userActionAttributes.payload.comment)) {
      const externalReferenceId = (0, _references.findReferenceId)(_constants2.EXTERNAL_REFERENCE_REF_NAME, userActionAttributes.payload.comment.externalReferenceStorage.soType, userAction.references);
      return {
        ...userAction.attributes.payload,
        comment: {
          ...userActionAttributes.payload.comment,
          externalReferenceId: externalReferenceId !== null && externalReferenceId !== void 0 ? externalReferenceId : ''
        }
      };
    }
    if ((0, _attachments.isCommentRequestTypePersistableState)(userActionAttributes.payload.comment)) {
      const injectedAttributes = (0, _so_references.injectPersistableReferencesToSO)(userActionAttributes.payload.comment, userAction.references, {
        persistableStateAttachmentTypeRegistry
      });
      return {
        ...userAction.attributes.payload,
        comment: {
          ...userActionAttributes.payload.comment,
          ...injectedAttributes
        }
      };
    }
  }
  return userAction.attributes.payload;
};
function getConnectorIdFromReferences(userAction) {
  const {
    references
  } = userAction;
  if ((0, _user_actions.isConnectorUserAction)(userAction.attributes) || (0, _user_actions.isCreateCaseUserAction)(userAction.attributes)) {
    var _findConnectorIdRefer, _findConnectorIdRefer2;
    return (_findConnectorIdRefer = (_findConnectorIdRefer2 = (0, _transform.findConnectorIdReference)(_constants2.CONNECTOR_ID_REFERENCE_NAME, references)) === null || _findConnectorIdRefer2 === void 0 ? void 0 : _findConnectorIdRefer2.id) !== null && _findConnectorIdRefer !== void 0 ? _findConnectorIdRefer : null;
  } else if ((0, _user_actions.isPushedUserAction)(userAction.attributes)) {
    var _findConnectorIdRefer3, _findConnectorIdRefer4;
    return (_findConnectorIdRefer3 = (_findConnectorIdRefer4 = (0, _transform.findConnectorIdReference)(_constants2.PUSH_CONNECTOR_ID_REFERENCE_NAME, references)) === null || _findConnectorIdRefer4 === void 0 ? void 0 : _findConnectorIdRefer4.id) !== null && _findConnectorIdRefer3 !== void 0 ? _findConnectorIdRefer3 : null;
  }
  return null;
}