"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMappings = void 0;
var _server = require("@kbn/actions-plugin/server");
var _api = require("../../../common/api");
var _error = require("../../common/error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMappings = async ({
  connector
}, clientArgs) => {
  const {
    unsecuredSavedObjectsClient,
    services: {
      connectorMappingsService
    },
    logger
  } = clientArgs;
  try {
    const myConnectorMappings = await connectorMappingsService.find({
      unsecuredSavedObjectsClient,
      options: {
        hasReference: {
          type: _server.ACTION_SAVED_OBJECT_TYPE,
          id: connector.id
        }
      }
    });
    if (myConnectorMappings.saved_objects.length === 0) {
      return null;
    }
    const so = myConnectorMappings.saved_objects[0];
    const res = {
      id: so.id,
      version: so.version,
      mappings: so.attributes.mappings
    };
    return (0, _api.decodeOrThrow)(_api.ConnectorMappingResponseRt)(res);
  } catch (error) {
    throw (0, _error.createCaseError)({
      message: `Failed to retrieve mapping connector id: ${connector.id} type: ${connector.type}: ${error}`,
      error,
      logger
    });
  }
};
exports.getMappings = getMappings;