"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateRegisteredAttachments = exports.validateFindCommentsPagination = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _constants = require("../../../common/constants");
var _attachments = require("../../../common/utils/attachments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateRegisteredAttachments = ({
  query,
  persistableStateAttachmentTypeRegistry,
  externalReferenceAttachmentTypeRegistry
}) => {
  if ((0, _attachments.isCommentRequestTypeExternalReference)(query) && !externalReferenceAttachmentTypeRegistry.has(query.externalReferenceAttachmentTypeId)) {
    throw _boom.default.badRequest(`Attachment type ${query.externalReferenceAttachmentTypeId} is not registered.`);
  }
  if ((0, _attachments.isCommentRequestTypePersistableState)(query) && !persistableStateAttachmentTypeRegistry.has(query.persistableStateAttachmentTypeId)) {
    throw _boom.default.badRequest(`Attachment type ${query.persistableStateAttachmentTypeId} is not registered.`);
  }
};
exports.validateRegisteredAttachments = validateRegisteredAttachments;
const validateFindCommentsPagination = params => {
  var _params$page, _params$perPage;
  if ((params === null || params === void 0 ? void 0 : params.page) == null && (params === null || params === void 0 ? void 0 : params.perPage) == null) {
    return;
  }
  const pageAsNumber = (_params$page = params.page) !== null && _params$page !== void 0 ? _params$page : 0;
  const perPageAsNumber = (_params$perPage = params.perPage) !== null && _params$perPage !== void 0 ? _params$perPage : 0;
  if (perPageAsNumber > _constants.MAX_COMMENTS_PER_PAGE) {
    throw _boom.default.badRequest(`The provided perPage value was too high. The maximum allowed perPage value is ${_constants.MAX_COMMENTS_PER_PAGE}.`);
  }
  if (Math.max(pageAsNumber, pageAsNumber * perPageAsNumber) > _constants.MAX_DOCS_PER_PAGE) {
    throw _boom.default.badRequest('The number of documents is too high. Paginating through more than 10,000 documents is not possible.');
  }
};
exports.validateFindCommentsPagination = validateFindCommentsPagination;