"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPushedUserActionBuilder = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _api = require("../../../common/api");
var _common = require("./common");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPushDates = (userActionPushedAt, connectorPushedAt) => {
  if (!connectorPushedAt) {
    return;
  }
  const pushedDate = new Date(userActionPushedAt);
  const connectorDate = new Date(connectorPushedAt);
  if (isNaN(pushedDate.getTime()) || isNaN(connectorDate.getTime())) {
    return;
  }
  return {
    userActionDate: pushedDate,
    connectorDate
  };
};
const isLatestPush = (pushedAt, latestPush) => {
  const dates = getPushDates(pushedAt, latestPush);
  if (!dates) {
    return false;
  }
  return dates.userActionDate.getTime() >= dates.connectorDate.getTime();
};
const isFirstPush = (pushedAt, oldestPush) => {
  const dates = getPushDates(pushedAt, oldestPush);
  if (!dates) {
    return true;
  }
  return dates.userActionDate.getTime() <= dates.connectorDate.getTime();
};
const getLabelTitle = (action, firstPush) => {
  const externalService = action.payload.externalService;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "xs",
    "data-test-subj": "pushed-service-label-title",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "pushed-label"
  }, `${firstPush ? i18n.PUSHED_NEW_INCIDENT : i18n.UPDATE_INCIDENT} ${externalService === null || externalService === void 0 ? void 0 : externalService.connectorName}`), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "pushed-value",
    href: externalService === null || externalService === void 0 ? void 0 : externalService.externalUrl,
    target: "_blank"
  }, externalService === null || externalService === void 0 ? void 0 : externalService.externalTitle)));
};
const getFooters = ({
  userAction,
  connectorInfo
}) => {
  var _connectorInfo$push$d;
  const footers = [];
  const latestPush = isLatestPush(userAction.createdAt, (_connectorInfo$push$d = connectorInfo.push.details) === null || _connectorInfo$push$d === void 0 ? void 0 : _connectorInfo$push$d.latestUserActionPushDate);
  const showTopFooter = userAction.action === _api.Actions.push_to_service && latestPush;
  const showBottomFooter = showTopFooter && connectorInfo.push.needsToBePushed;
  if (showTopFooter) {
    footers.push({
      username: '',
      event: i18n.ALREADY_PUSHED_TO_SERVICE(`${connectorInfo.name}`),
      timelineAvatar: 'sortUp',
      'data-test-subj': 'top-footer'
    });
  }
  if (showBottomFooter) {
    footers.push({
      username: '',
      event: i18n.REQUIRED_UPDATE_TO_SERVICE(`${connectorInfo.name}`),
      timelineAvatar: 'sortDown',
      'data-test-subj': 'bottom-footer'
    });
  }
  return footers;
};
const createPushedUserActionBuilder = ({
  userAction,
  userProfiles,
  caseConnectors,
  handleOutlineComment
}) => ({
  build: () => {
    var _connectorInfo$push$d2;
    const pushedUserAction = userAction;
    const connectorId = pushedUserAction.payload.externalService.connectorId;
    const connectorInfo = caseConnectors[connectorId];
    if (!connectorInfo) {
      return [];
    }
    const firstPush = isFirstPush(userAction.createdAt, (_connectorInfo$push$d2 = connectorInfo.push.details) === null || _connectorInfo$push$d2 === void 0 ? void 0 : _connectorInfo$push$d2.oldestUserActionPushDate);
    const footers = getFooters({
      userAction: pushedUserAction,
      connectorInfo
    });
    const label = getLabelTitle(pushedUserAction, firstPush);
    const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
      userProfiles,
      userAction,
      handleOutlineComment,
      label,
      icon: 'dot'
    });
    return [...commonBuilder.build(), ...footers];
  }
});
exports.createPushedUserActionBuilder = createPushedUserActionBuilder;