"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CallOut = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _types = require("./types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CallOutComponent = ({
  handleButtonClick,
  id,
  messages,
  type,
  hasLicenseError
}) => {
  const handleCallOut = (0, _react.useCallback)(e => handleButtonClick(e, id, type), [handleButtonClick, id, type]);
  const isCaseClosed = (0, _react.useMemo)(() => messages.map(m => m.id).includes(_types.CLOSED_CASE_PUSH_ERROR_ID), [messages]);
  return !(0, _fp.isEmpty)(messages) ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: isCaseClosed ? i18n.PUSH_DISABLE_BECAUSE_CASE_CLOSED_TITLE : hasLicenseError ? i18n.PUSH_DISABLE_BY_LICENSE_TITLE : i18n.ERROR_PUSH_SERVICE_CALLOUT_TITLE,
    color: type,
    iconType: "gear",
    "data-test-subj": `case-callout-${id}`,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": `callout-messages-${id}`,
    listItems: messages
  }), !isCaseClosed && !hasLicenseError && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": `callout-onclick-${id}`,
    color: type === 'success' ? 'success' : type,
    onClick: handleCallOut
  }, i18n.ADD_CONNECTOR)) : null;
};
CallOutComponent.displayName = 'CallOut';
const CallOut = /*#__PURE__*/(0, _react.memo)(CallOutComponent);
exports.CallOut = CallOut;