"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePlugins = void 0;
var _eui = require("@elastic/eui");
var _react = require("react");
var _use_timeline_context = require("../timeline_context/use_timeline_context");
var _kibana = require("../../common/lib/kibana");
var lensMarkdownPlugin = _interopRequireWildcard(require("./plugins/lens"));
var _constants = require("./plugins/lens/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePlugins = disabledPlugins => {
  var _useTimelineContext, _kibanaConfig$markdow2;
  const kibanaConfig = _kibana.KibanaServices.getConfig();
  const timelinePlugins = (_useTimelineContext = (0, _use_timeline_context.useTimelineContext)()) === null || _useTimelineContext === void 0 ? void 0 : _useTimelineContext.editor_plugins;
  const appCapabilities = (0, _kibana.useApplicationCapabilities)();
  return (0, _react.useMemo)(() => {
    var _kibanaConfig$markdow;
    const uiPlugins = (0, _eui.getDefaultEuiMarkdownUiPlugins)();
    const parsingPlugins = (0, _eui.getDefaultEuiMarkdownParsingPlugins)();
    const processingPlugins = (0, _eui.getDefaultEuiMarkdownProcessingPlugins)();
    if (timelinePlugins) {
      uiPlugins.push(timelinePlugins.uiPlugin);
      parsingPlugins.push(timelinePlugins.parsingPlugin);

      // This line of code is TS-compatible and it will break if [1][1] change in the future.
      processingPlugins[1][1].components.timeline = timelinePlugins.processingPluginRenderer;
    }
    if (kibanaConfig !== null && kibanaConfig !== void 0 && (_kibanaConfig$markdow = kibanaConfig.markdownPlugins) !== null && _kibanaConfig$markdow !== void 0 && _kibanaConfig$markdow.lens && !(disabledPlugins !== null && disabledPlugins !== void 0 && disabledPlugins.includes(_constants.ID)) && appCapabilities !== null && appCapabilities !== void 0 && appCapabilities.visualize.crud) {
      uiPlugins.push(lensMarkdownPlugin.plugin);
    }
    parsingPlugins.push(lensMarkdownPlugin.parser);
    // This line of code is TS-compatible and it will break if [1][1] change in the future.
    processingPlugins[1][1].components.lens = lensMarkdownPlugin.renderer;
    return {
      uiPlugins,
      parsingPlugins,
      processingPlugins
    };
  }, [appCapabilities === null || appCapabilities === void 0 ? void 0 : appCapabilities.visualize.crud, disabledPlugins, kibanaConfig === null || kibanaConfig === void 0 ? void 0 : (_kibanaConfig$markdow2 = kibanaConfig.markdownPlugins) === null || _kibanaConfig$markdow2 === void 0 ? void 0 : _kibanaConfig$markdow2.lens, timelinePlugins]);
};
exports.usePlugins = usePlugins;