"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _navigation = require("../../common/navigation");
var _link_icon = require("../link_icon");
var _title = require("./title");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Header = _styledComponents.default.header.attrs({
  className: 'casesHeaderPage'
})`
  ${({
  border,
  theme
}) => (0, _styledComponents.css)`
    margin-bottom: ${theme.eui.euiSizeL};

    ${border && (0, _styledComponents.css)`
      border-bottom: ${theme.eui.euiBorderThin};
      padding-bottom: ${theme.eui.euiSizeL};
      .euiProgress {
        top: ${theme.eui.euiSizeL};
      }
    `}
  `}
`;
Header.displayName = 'Header';
const FlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  display: block;
`;
FlexItem.displayName = 'FlexItem';
const LinkBack = _styledComponents.default.div.attrs({
  className: 'casesHeaderPage__linkBack'
})`
  ${({
  theme
}) => (0, _styledComponents.css)`
    font-size: ${theme.eui.euiFontSizeXS};
    line-height: ${theme.eui.euiLineHeight};
    margin-bottom: ${theme.eui.euiSizeS};
  `}
`;
LinkBack.displayName = 'LinkBack';
const HeaderPageComponent = ({
  showBackButton = false,
  border,
  children,
  isLoading,
  title,
  titleNode,
  'data-test-subj': dataTestSubj
}) => {
  const {
    releasePhase
  } = (0, _use_cases_context.useCasesContext)();
  const {
    getAllCasesUrl,
    navigateToAllCases
  } = (0, _navigation.useAllCasesNavigation)();
  const navigateToAllCasesClick = (0, _react.useCallback)(e => {
    if (e) {
      e.preventDefault();
    }
    navigateToAllCases();
  }, [navigateToAllCases]);
  return /*#__PURE__*/_react.default.createElement(Header, {
    border: border,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(FlexItem, null, showBackButton && /*#__PURE__*/_react.default.createElement(LinkBack, null, /*#__PURE__*/_react.default.createElement(_link_icon.LinkIcon, {
    dataTestSubj: "backToCases",
    onClick: navigateToAllCasesClick,
    href: getAllCasesUrl(),
    iconType: "arrowLeft"
  }, i18n.BACK_TO_ALL)), titleNode || /*#__PURE__*/_react.default.createElement(_title.Title, {
    title: title,
    releasePhase: releasePhase
  }), border && isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent"
  })), children && /*#__PURE__*/_react.default.createElement(FlexItem, {
    "data-test-subj": "header-page-supplements",
    grow: false
  }, children)));
};
HeaderPageComponent.displayName = 'HeaderPage';
const HeaderPage = /*#__PURE__*/_react.default.memo(HeaderPageComponent);
exports.HeaderPage = HeaderPage;