"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemaTags = exports.schema = void 0;
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _validators = require("../../../common/utils/validators");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _optional_field_label = require("./optional_field_label");
var _translations2 = require("../severity/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  maxLengthField
} = _helpers.fieldValidators;
const schemaTags = {
  type: _hook_form_lib.FIELD_TYPES.COMBO_BOX,
  label: i18n.TAGS,
  helpText: i18n.TAGS_HELP,
  labelAppend: _optional_field_label.OptionalFieldLabel,
  validations: [{
    validator: ({
      value
    }) => {
      if (!Array.isArray(value) && (0, _validators.isInvalidTag)(value) || Array.isArray(value) && value.length > 0 && value.find(_validators.isInvalidTag)) {
        return {
          message: i18n.TAGS_EMPTY_ERROR
        };
      }
    },
    type: _hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM,
    isBlocking: false
  }]
};
exports.schemaTags = schemaTags;
const schema = {
  title: {
    type: _hook_form_lib.FIELD_TYPES.TEXT,
    label: i18n.NAME,
    validations: [{
      validator: emptyField(i18n.TITLE_REQUIRED)
    }, {
      validator: maxLengthField({
        length: _constants.MAX_TITLE_LENGTH,
        message: i18n.MAX_LENGTH_ERROR('name', _constants.MAX_TITLE_LENGTH)
      })
    }]
  },
  description: {
    label: i18n.DESCRIPTION,
    validations: [{
      validator: emptyField(i18n.DESCRIPTION_REQUIRED)
    }]
  },
  selectedOwner: {
    label: i18n.SOLUTION,
    type: _hook_form_lib.FIELD_TYPES.RADIO_GROUP,
    validations: [{
      validator: emptyField(i18n.SOLUTION_REQUIRED)
    }]
  },
  tags: schemaTags,
  severity: {
    label: _translations2.SEVERITY_TITLE
  },
  connectorId: {
    type: _hook_form_lib.FIELD_TYPES.SUPER_SELECT,
    label: i18n.CONNECTORS,
    defaultValue: 'none'
  },
  fields: {
    defaultValue: null
  },
  syncAlerts: {
    helpText: i18n.SYNC_ALERTS_HELP,
    type: _hook_form_lib.FIELD_TYPES.TOGGLE,
    defaultValue: true
  },
  assignees: {},
  category: {}
};
exports.schema = schema;