"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _api = require("../../../../common/api");
var _card = require("../card");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CasesWebhookPreviewComponent = ({
  connector
}) => {
  var _connector$config, _connector$config2;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _api.ConnectorTypes.casesWebhook,
    isLoading: false,
    listItems: [],
    title: connector.name
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), (!((_connector$config = connector.config) !== null && _connector$config !== void 0 && _connector$config.createCommentUrl) || !((_connector$config2 = connector.config) !== null && _connector$config2 !== void 0 && _connector$config2.createCommentJson)) && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.CREATE_COMMENT_WARNING_TITLE,
    color: "warning",
    iconType: "help",
    "data-test-subj": "create-comment-warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.CREATE_COMMENT_WARNING_DESC(connector.name))));
};
exports.default = CasesWebhookPreviewComponent;
CasesWebhookPreviewComponent.displayName = 'CasesWebhookPreview';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;