"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _connectors_dropdown = require("../configure_cases/connectors_dropdown");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EuiFormRowWrapper = (0, _styledComponents.default)(_eui.EuiFormRow)`
  .euiFormErrorText {
    display: none;
  }
`;
const ConnectorSelector = ({
  connectors,
  dataTestSubj,
  disabled = false,
  field,
  idAria,
  isLoading = false,
  handleChange
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const onChange = (0, _react.useCallback)(val => {
    if (handleChange) {
      handleChange(val);
    }
    field.setValue(val);
  }, [handleChange, field]);
  return /*#__PURE__*/_react.default.createElement(EuiFormRowWrapper, {
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    error: errorMessage,
    fullWidth: true,
    helpText: field.helpText,
    isInvalid: isInvalid,
    label: field.label,
    labelAppend: field.labelAppend
  }, /*#__PURE__*/_react.default.createElement(_connectors_dropdown.ConnectorsDropdown, {
    connectors: connectors,
    disabled: disabled,
    isLoading: isLoading,
    onChange: onChange,
    selectedConnector: (0, _fp.isEmpty)(field.value) ? 'none' : field.value
  }));
};
exports.ConnectorSelector = ConnectorSelector;
ConnectorSelector.displayName = 'ConnectorSelector';