"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _navigation = require("../../../common/navigation");
var i18n = _interopRequireWildcard(require("../translations"));
var _hoverable_user_with_avatar = require("../../user_profiles/hoverable_user_with_avatar");
var _user_converter = require("../../user_profiles/user_converter");
var _sort = require("../../user_profiles/sort");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    margin-top: ${theme.eui.euiSizeM};
  `}
`;
const renderUsers = (users, handleSendEmail) => users.map((userInfo, key) => {
  var _userInfo$user, _userInfo$user2, _userInfo$user3, _userInfo$user$userna, _userInfo$user4, _userInfo$user5;
  return /*#__PURE__*/_react.default.createElement(MyFlexGroup, {
    key: key,
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar.HoverableUserWithAvatar, {
    userInfo: userInfo
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "user-list-email-button",
    onClick: handleSendEmail.bind(null, (_userInfo$user = userInfo.user) === null || _userInfo$user === void 0 ? void 0 : _userInfo$user.email),
    iconType: "email",
    "aria-label": i18n.SEND_EMAIL_ARIA((_userInfo$user2 = userInfo.user) !== null && _userInfo$user2 !== void 0 && _userInfo$user2.full_name ? (_userInfo$user3 = userInfo.user) === null || _userInfo$user3 === void 0 ? void 0 : _userInfo$user3.full_name : (_userInfo$user$userna = (_userInfo$user4 = userInfo.user) === null || _userInfo$user4 === void 0 ? void 0 : _userInfo$user4.username) !== null && _userInfo$user$userna !== void 0 ? _userInfo$user$userna : ''),
    isDisabled: (0, _fp.isEmpty)((_userInfo$user5 = userInfo.user) === null || _userInfo$user5 === void 0 ? void 0 : _userInfo$user5.email)
  })));
});
const getEmailContent = ({
  caseTitle,
  caseUrl
}) => ({
  subject: i18n.EMAIL_SUBJECT(caseTitle),
  body: i18n.EMAIL_BODY(caseUrl)
});
const UserList = /*#__PURE__*/_react.default.memo(({
  theCase,
  userProfiles,
  headline,
  loading,
  users,
  dataTestSubj
}) => {
  const {
    getCaseViewUrl
  } = (0, _navigation.useCaseViewNavigation)();
  const caseUrl = getCaseViewUrl({
    detailName: theCase.id
  });
  const email = getEmailContent({
    caseTitle: theCase.title,
    caseUrl
  });
  const handleSendEmail = (0, _react.useCallback)(emailAddress => {
    if (emailAddress && emailAddress != null) {
      window.open(`mailto:${emailAddress}?subject=${email.subject}&body=${email.body}`, '_blank');
    }
  }, [email.body, email.subject]);
  const validUsers = getValidUsers(users, userProfiles !== null && userProfiles !== void 0 ? userProfiles : new Map());
  const orderedUsers = (0, _lodash.sortBy)(validUsers, _sort.getSortField);
  if (orderedUsers.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement("h4", null, headline), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), loading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null))), renderUsers(orderedUsers, handleSendEmail)));
});
exports.UserList = UserList;
UserList.displayName = 'UserList';
const getValidUsers = (users, userProfiles) => {
  const validUsers = users.reduce((acc, user) => {
    const userCamelCase = {
      email: user.user.email,
      fullName: user.user.full_name,
      username: user.user.username,
      profileUid: user.uid
    };
    const convertedUser = (0, _user_converter.convertToUserInfo)(userCamelCase, userProfiles);
    if (convertedUser != null) {
      acc.set(convertedUser.key, convertedUser.userInfo);
    }
    return acc;
  }, new Map());
  return Array.from(validUsers.values());
};