"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseUrlQueryParams = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseUrlQueryParams = parsedUrlParams => {
  const urlParams = {
    ...(parsedUrlParams.sortField && {
      sortField: parsedUrlParams.sortField
    }),
    ...(parsedUrlParams.sortOrder && {
      sortOrder: parsedUrlParams.sortOrder
    })
  };
  const intPage = parsedUrlParams.page && parseInt(parsedUrlParams.page, 10);
  const intPerPage = parsedUrlParams.perPage && parseInt(parsedUrlParams.perPage, 10);

  // page=0 is deliberately ignored
  if (intPage) {
    urlParams.page = intPage;
  }

  // perPage=0 is deliberately ignored
  if (intPerPage) {
    urlParams.perPage = intPerPage;
  }
  return urlParams;
};
exports.parseUrlQueryParams = parseUrlQueryParams;