"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesTableUtilityBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_on_refresh_cases = require("./use_on_refresh_cases");
var _use_bulk_actions = require("./use_bulk_actions");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CasesTableUtilityBar = /*#__PURE__*/_react.default.memo(({
  isSelectorView,
  totalCases,
  selectedCases,
  deselectCases
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const refreshCases = (0, _use_on_refresh_cases.useRefreshCases)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const onRefresh = (0, _react.useCallback)(() => {
    deselectCases();
    refreshCases();
  }, [deselectCases, refreshCases]);
  const {
    panels,
    modals,
    flyouts
  } = (0, _use_bulk_actions.useBulkActions)({
    selectedCases,
    onAction: closePopover,
    onActionSuccess: onRefresh
  });

  /**
   * At least update or delete permissions needed to show bulk actions.
   * Granular permission check for each action is performed
   * in the useBulkActions hook.
   */
  const showBulkActions = (permissions.update || permissions.delete) && selectedCases.length > 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s",
    css: {
      borderBottom: euiTheme.border.thin,
      marginTop: 0,
      marginBottom: 0,
      paddingTop: euiTheme.size.s,
      paddingBottom: euiTheme.size.s
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-table-case-count",
    grow: false,
    css: {
      borderRight: euiTheme.border.thin,
      paddingRight: euiTheme.size.s
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, i18n.SHOWING_CASES(totalCases))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-table-utility-bar-actions",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "s"
  }, !isSelectorView && showBulkActions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-table-selected-case-count",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, i18n.SHOWING_SELECTED_CASES(selectedCases.length))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    "data-test-subj": "case-table-bulk-actions-popover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: togglePopover,
      size: "xs",
      iconSide: "right",
      iconType: "arrowDown",
      flush: "left",
      "data-test-subj": "case-table-bulk-actions-link-icon"
    }, i18n.BULK_ACTIONS)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    panels: panels,
    initialPanelId: 0,
    "data-test-subj": "case-table-bulk-actions-context-menu"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onRefresh,
    size: "xs",
    iconSide: "left",
    iconType: "refresh",
    flush: "left",
    "data-test-subj": "all-cases-refresh-link-icon"
  }, i18n.REFRESH))))), modals, flyouts);
});
exports.CasesTableUtilityBar = CasesTableUtilityBar;
CasesTableUtilityBar.displayName = 'CasesTableUtilityBar';