"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _status = require("@kbn/cases-components/src/status/status");
var _status2 = require("../status");
var _types = require("../../../common/ui/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AllStatusBadge = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "status-badge-all",
    color: _status2.allCaseStatus[_types.StatusAll].color
  }, _status2.allCaseStatus[_types.StatusAll].label);
};
AllStatusBadge.displayName = 'AllStatusBadge';
const StatusFilterComponent = ({
  stats,
  selectedStatus,
  onStatusChanged,
  hiddenStatuses = []
}) => {
  const caseStatuses = Object.keys(_status2.statuses);
  const options = [_types.StatusAll, ...caseStatuses].filter(status => !hiddenStatuses.includes(status)).map(status => ({
    value: status,
    inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: 'center',
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("span", null, status === 'all' ? /*#__PURE__*/_react.default.createElement(AllStatusBadge, null) : /*#__PURE__*/_react.default.createElement(_status.Status, {
      status: status
    }))), status !== _types.StatusAll && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, ` (${stats[status]})`)),
    'data-test-subj': `case-status-filter-${status}`
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: options,
    valueOfSelected: selectedStatus,
    onChange: onStatusChanged,
    "data-test-subj": "case-status-filter"
  });
};
StatusFilterComponent.displayName = 'StatusFilter';
const StatusFilter = /*#__PURE__*/(0, _react.memo)(StatusFilterComponent);
exports.StatusFilter = StatusFilter;