"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllCasesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _types = require("../../../common/ui/types");
var _api = require("../../../common/api");
var _constants = require("../../../common/constants");
var _use_available_owners = require("../app/use_available_owners");
var _use_cases_columns = require("./use_cases_columns");
var _table_filters = require("./table_filters");
var _types2 = require("./types");
var _table = require("./table");
var _use_cases_context = require("../cases_context/use_cases_context");
var _cases_metrics = require("./cases_metrics");
var _use_get_supported_action_connectors = require("../../containers/configure/use_get_supported_action_connectors");
var _use_get_cases = require("../../containers/use_get_cases");
var _use_bulk_get_user_profiles = require("../../containers/user_profiles/use_bulk_get_user_profiles");
var _use_get_current_user_profile = require("../../containers/user_profiles/use_get_current_user_profile");
var _permissions = require("../../utils/permissions");
var _use_is_loading_cases = require("./use_is_loading_cases");
var _use_all_cases_state = require("./use_all_cases_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProgressLoader = (0, _styledComponents.default)(_eui.EuiProgress)`
  ${({
  $isShow
}) => $isShow ? (0, _styledComponents.css)`
          top: 2px;
          border-radius: ${({
  theme
}) => theme.eui.euiBorderRadius};
          z-index: ${({
  theme
}) => theme.eui.euiZHeader};
        ` : `
      display: none;
    `}
`;
const getSortField = field => {
  var _SortFieldCase$field;
  return (// @ts-ignore
    (_SortFieldCase$field = _types.SortFieldCase[field]) !== null && _SortFieldCase$field !== void 0 ? _SortFieldCase$field : _types.SortFieldCase.title
  );
};
const isValidSolution = solution => Object.keys(_constants.OWNER_INFO).includes(solution);
const mapToReadableSolutionName = solution => {
  if (isValidSolution(solution)) {
    return _constants.OWNER_INFO[solution];
  }
  return {
    id: solution,
    label: solution,
    iconType: ''
  };
};
const AllCasesList = /*#__PURE__*/_react.default.memo(({
  hiddenStatuses = [],
  isSelectorView = false,
  onRowClick
}) => {
  var _filterOptions$status;
  const {
    owner,
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const availableSolutions = (0, _use_available_owners.useAvailableCasesOwners)((0, _permissions.getAllPermissionsExceptFrom)('delete'));
  const isLoading = (0, _use_is_loading_cases.useIsLoadingCases)();
  const hasOwner = !!owner.length;
  const firstAvailableStatus = (0, _fp.head)((0, _fp.difference)(_api.caseStatuses, hiddenStatuses));
  const initialFilterOptions = {
    ...(!(0, _fp.isEmpty)(hiddenStatuses) && firstAvailableStatus && {
      status: firstAvailableStatus
    }),
    owner: hasOwner ? owner : availableSolutions
  };
  const {
    queryParams,
    setQueryParams,
    filterOptions,
    setFilterOptions
  } = (0, _use_all_cases_state.useAllCasesState)(isSelectorView, initialFilterOptions);
  const [selectedCases, setSelectedCases] = (0, _react.useState)([]);
  const {
    data = _use_get_cases.initialData,
    isFetching: isLoadingCases
  } = (0, _use_get_cases.useGetCases)({
    filterOptions,
    queryParams
  });
  const assigneesFromCases = (0, _react.useMemo)(() => {
    return data.cases.reduce((acc, caseInfo) => {
      if (!caseInfo) {
        return acc;
      }
      for (const assignee of caseInfo.assignees) {
        acc.add(assignee.uid);
      }
      return acc;
    }, new Set());
  }, [data.cases]);
  const {
    data: userProfiles
  } = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids: Array.from(assigneesFromCases)
  });
  const {
    data: currentUserProfile,
    isLoading: isLoadingCurrentUserProfile
  } = (0, _use_get_current_user_profile.useGetCurrentUserProfile)();
  const {
    data: connectors = []
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: queryParams.sortField,
      direction: queryParams.sortOrder
    }
  }), [queryParams.sortField, queryParams.sortOrder]);
  const tableRef = (0, _react.useRef)(null);
  const deselectCases = (0, _react.useCallback)(() => {
    var _tableRef$current;
    setSelectedCases([]);
    (_tableRef$current = tableRef.current) === null || _tableRef$current === void 0 ? void 0 : _tableRef$current.setSelection([]);
  }, [setSelectedCases]);
  const tableOnChangeCallback = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    let newQueryParams = queryParams;
    if (sort) {
      newQueryParams = {
        ...newQueryParams,
        sortField: getSortField(sort.field),
        sortOrder: sort.direction
      };
    }
    if (page) {
      newQueryParams = {
        ...newQueryParams,
        page: page.index + 1,
        perPage: page.size
      };
    }
    setQueryParams(newQueryParams);
    deselectCases();
  }, [queryParams, deselectCases, setQueryParams]);
  const onFilterChangedCallback = (0, _react.useCallback)(newFilterOptions => {
    if ((newFilterOptions === null || newFilterOptions === void 0 ? void 0 : newFilterOptions.status) === _api.CaseStatuses.closed && queryParams.sortField === _types.SortFieldCase.createdAt) {
      setQueryParams({
        sortField: _types.SortFieldCase.closedAt
      });
    } else if (newFilterOptions.status && [_api.CaseStatuses.open, _api.CaseStatuses['in-progress'], _types.StatusAll].includes(newFilterOptions.status) && queryParams.sortField === _types.SortFieldCase.closedAt) {
      setQueryParams({
        sortField: _types.SortFieldCase.createdAt
      });
    }
    deselectCases();
    setFilterOptions({
      ...newFilterOptions,
      /**
       * If the user selects and deselects all solutions
       * then the owner is set to an empty array. This results in fetching all cases the user has access to including
       * the ones with read access. We want to show only the cases the user has full access to.
       * For that reason we fallback to availableSolutions if the owner is empty.
       *
       * If the consumer of cases has passed an owner we fallback to the provided owner
       */
      ...(newFilterOptions.owner != null && !hasOwner ? {
        owner: newFilterOptions.owner.length === 0 ? availableSolutions : newFilterOptions.owner
      } : newFilterOptions.owner != null && hasOwner ? {
        owner: newFilterOptions.owner.length === 0 ? owner : newFilterOptions.owner
      } : {})
    });
  }, [queryParams.sortField, deselectCases, setFilterOptions, hasOwner, availableSolutions, owner, setQueryParams]);
  const {
    columns
  } = (0, _use_cases_columns.useCasesColumns)({
    filterStatus: (_filterOptions$status = filterOptions.status) !== null && _filterOptions$status !== void 0 ? _filterOptions$status : _types.StatusAll,
    userProfiles: userProfiles !== null && userProfiles !== void 0 ? userProfiles : new Map(),
    isSelectorView,
    connectors,
    onRowClick,
    showSolutionColumn: !hasOwner && availableSolutions.length > 1,
    disableActions: selectedCases.length > 0
  });
  const pagination = (0, _react.useMemo)(() => {
    var _data$total;
    return {
      pageIndex: queryParams.page - 1,
      pageSize: queryParams.perPage,
      totalItemCount: (_data$total = data.total) !== null && _data$total !== void 0 ? _data$total : 0,
      pageSizeOptions: _types2.CASES_TABLE_PERPAGE_VALUES
    };
  }, [data, queryParams]);
  const euiBasicTableSelectionProps = (0, _react.useMemo)(() => ({
    onSelectionChange: setSelectedCases,
    initialSelected: selectedCases,
    selectable: () => !(0, _permissions.isReadOnlyPermissions)(permissions)
  }), [permissions, selectedCases]);
  const isDataEmpty = (0, _react.useMemo)(() => data.total === 0, [data]);
  const tableRowProps = (0, _react.useCallback)(theCase => ({
    'data-test-subj': `cases-table-row-${theCase.id}`
  }), []);
  const availableSolutionsLabels = availableSolutions.map(solution => mapToReadableSolutionName(solution));
  const onCreateCasePressed = (0, _react.useCallback)(() => {
    onRowClick === null || onRowClick === void 0 ? void 0 : onRowClick(undefined, true);
  }, [onRowClick]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ProgressLoader, {
    size: "xs",
    color: "accent",
    className: "essentialAnimation",
    $isShow: isLoading || isLoadingCases
  }), !isSelectorView ? /*#__PURE__*/_react.default.createElement(_cases_metrics.CasesMetrics, null) : null, /*#__PURE__*/_react.default.createElement(_table_filters.CasesTableFilters, {
    countClosedCases: data.countClosedCases,
    countOpenCases: data.countOpenCases,
    countInProgressCases: data.countInProgressCases,
    onFilterChanged: onFilterChangedCallback,
    availableSolutions: hasOwner ? [] : availableSolutionsLabels,
    initial: {
      search: filterOptions.search,
      searchFields: filterOptions.searchFields,
      assignees: filterOptions.assignees,
      reporters: filterOptions.reporters,
      tags: filterOptions.tags,
      status: filterOptions.status,
      owner: filterOptions.owner,
      severity: filterOptions.severity,
      category: filterOptions.category
    },
    hiddenStatuses: hiddenStatuses,
    onCreateCasePressed: onCreateCasePressed,
    isSelectorView: isSelectorView,
    isLoading: isLoadingCurrentUserProfile,
    currentUserProfile: currentUserProfile
  }), /*#__PURE__*/_react.default.createElement(_table.CasesTable, {
    columns: columns,
    data: data,
    goToCreateCase: onRowClick ? onCreateCasePressed : undefined,
    isCasesLoading: isLoadingCases,
    isCommentUpdating: isLoadingCases,
    isDataEmpty: isDataEmpty,
    isSelectorView: isSelectorView,
    onChange: tableOnChangeCallback,
    pagination: pagination,
    selectedCases: selectedCases,
    selection: euiBasicTableSelectionProps,
    sorting: sorting,
    tableRef: tableRef,
    tableRowProps: tableRowProps,
    deselectCases: deselectCases
  }));
});
exports.AllCasesList = AllCasesList;
AllCasesList.displayName = 'AllCasesList';