"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ADD_TAG_CUSTOM_OPTION_LABEL", {
  enumerable: true,
  get: function () {
    return _translations.ADD_TAG_CUSTOM_OPTION_LABEL;
  }
});
Object.defineProperty(exports, "CANCEL", {
  enumerable: true,
  get: function () {
    return _translations.CANCEL;
  }
});
Object.defineProperty(exports, "EDITED_CASES", {
  enumerable: true,
  get: function () {
    return _translations2.EDITED_CASES;
  }
});
exports.NO_TAGS_AVAILABLE = exports.NO_SEARCH_MATCH = exports.EDIT_TAGS = void 0;
Object.defineProperty(exports, "SAVE_SELECTION", {
  enumerable: true,
  get: function () {
    return _translations2.SAVE_SELECTION;
  }
});
Object.defineProperty(exports, "SEARCH_PLACEHOLDER", {
  enumerable: true,
  get: function () {
    return _translations2.SEARCH_PLACEHOLDER;
  }
});
Object.defineProperty(exports, "SELECTED_CASES", {
  enumerable: true,
  get: function () {
    return _translations2.SELECTED_CASES;
  }
});
exports.TOTAL_TAGS = exports.SELECT_NONE = exports.SELECT_ALL = exports.SELECTED_TAGS = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../../common/translations");
var _translations2 = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDIT_TAGS = _i18n.i18n.translate('xpack.cases.actions.tags.edit', {
  defaultMessage: 'Edit tags'
});
exports.EDIT_TAGS = EDIT_TAGS;
const TOTAL_TAGS = totalTags => _i18n.i18n.translate('xpack.cases.actions.tags.totalTags', {
  defaultMessage: 'Total tags: {totalTags}',
  values: {
    totalTags
  }
});
exports.TOTAL_TAGS = TOTAL_TAGS;
const SELECT_ALL = _i18n.i18n.translate('xpack.cases.actions.tags.selectAll', {
  defaultMessage: 'Select all'
});
exports.SELECT_ALL = SELECT_ALL;
const SELECT_NONE = _i18n.i18n.translate('xpack.cases.actions.tags.selectNone', {
  defaultMessage: 'Select none'
});
exports.SELECT_NONE = SELECT_NONE;
const SELECTED_TAGS = selectedTags => _i18n.i18n.translate('xpack.cases.actions.tags.selectedTags', {
  defaultMessage: 'Selected: {selectedTags}',
  values: {
    selectedTags
  }
});
exports.SELECTED_TAGS = SELECTED_TAGS;
const NO_TAGS_AVAILABLE = _i18n.i18n.translate('xpack.cases.actions.tags.noTagsAvailable', {
  defaultMessage: 'No tags available. To add a tag, enter it in the query bar'
});
exports.NO_TAGS_AVAILABLE = NO_TAGS_AVAILABLE;
const NO_SEARCH_MATCH = _i18n.i18n.translate('xpack.cases.actions.tags.noTagsMatch', {
  defaultMessage: 'No tags match your search'
});
exports.NO_SEARCH_MATCH = NO_SEARCH_MATCH;