"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormMock = exports.useFormDataMock = exports.mockFormHook = exports.getFormMock = void 0;
var _use_form = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib/hooks/use_form");
var _use_form_data = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib/hooks/use_form_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

jest.mock('@kbn/es-ui-shared-plugin/static/forms/hook_form_lib/hooks/use_form');
jest.mock('@kbn/es-ui-shared-plugin/static/forms/hook_form_lib/hooks/use_form_data');
const mockFormHook = {
  isSubmitted: false,
  isSubmitting: false,
  isValid: true,
  submit: jest.fn(),
  subscribe: jest.fn(),
  setFieldValue: jest.fn(),
  setFieldErrors: jest.fn(),
  getFields: jest.fn(),
  getFormData: jest.fn(),
  getFieldDefaultValue: jest.fn(),
  /* Returns a list of all errors in the form */
  getErrors: jest.fn(),
  reset: jest.fn(),
  __options: {},
  __formData$: {},
  __addField: jest.fn(),
  __removeField: jest.fn(),
  __validateFields: jest.fn(),
  __updateFormDataAt: jest.fn(),
  __readFieldConfigFromSchema: jest.fn()
};
exports.mockFormHook = mockFormHook;
const getFormMock = sampleData => ({
  ...mockFormHook,
  submit: () => Promise.resolve({
    data: sampleData,
    isValid: true
  }),
  getFormData: () => sampleData
});
exports.getFormMock = getFormMock;
const useFormMock = _use_form.useForm;
exports.useFormMock = useFormMock;
const useFormDataMock = _use_form_data.useFormData;
exports.useFormDataMock = useFormDataMock;